package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface OAuthAuthorizeTokenFluent<A extends OAuthAuthorizeTokenFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getClientName();
    public A withClientName(String clientName);
    public Boolean hasClientName();
    public A withNewClientName(String arg1);
    public A withNewClientName(StringBuilder arg1);
    public A withNewClientName(StringBuffer arg1);
    public String getCodeChallenge();
    public A withCodeChallenge(String codeChallenge);
    public Boolean hasCodeChallenge();
    public A withNewCodeChallenge(String arg1);
    public A withNewCodeChallenge(StringBuilder arg1);
    public A withNewCodeChallenge(StringBuffer arg1);
    public String getCodeChallengeMethod();
    public A withCodeChallengeMethod(String codeChallengeMethod);
    public Boolean hasCodeChallengeMethod();
    public A withNewCodeChallengeMethod(String arg1);
    public A withNewCodeChallengeMethod(StringBuilder arg1);
    public A withNewCodeChallengeMethod(StringBuffer arg1);
    public Long getExpiresIn();
    public A withExpiresIn(Long expiresIn);
    public Boolean hasExpiresIn();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OAuthAuthorizeTokenFluent.MetadataNested<A> editMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadata();
    public OAuthAuthorizeTokenFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getRedirectURI();
    public A withRedirectURI(String redirectURI);
    public Boolean hasRedirectURI();
    public A withNewRedirectURI(String arg1);
    public A withNewRedirectURI(StringBuilder arg1);
    public A withNewRedirectURI(StringBuffer arg1);
    public A addToScopes(int index,String item);
    public A setToScopes(int index,String item);
    public A addToScopes(String... items);
    public A addAllToScopes(Collection<String> items);
    public A removeFromScopes(String... items);
    public A removeAllFromScopes(Collection<String> items);
    public List<String> getScopes();
    public String getScope(int index);
    public String getFirstScope();
    public String getLastScope();
    public String getMatchingScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingScope(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withScopes(List<String> scopes);
    public A withScopes(String... scopes);
    public Boolean hasScopes();
    public A addNewScope(String arg1);
    public A addNewScope(StringBuilder arg1);
    public A addNewScope(StringBuffer arg1);
    public String getState();
    public A withState(String state);
    public Boolean hasState();
    public A withNewState(String arg1);
    public A withNewState(StringBuilder arg1);
    public A withNewState(StringBuffer arg1);
    public String getUserName();
    public A withUserName(String userName);
    public Boolean hasUserName();
    public A withNewUserName(String arg1);
    public A withNewUserName(StringBuilder arg1);
    public A withNewUserName(StringBuffer arg1);
    public String getUserUID();
    public A withUserUID(String userUID);
    public Boolean hasUserUID();
    public A withNewUserUID(String arg1);
    public A withNewUserUID(StringBuilder arg1);
    public A withNewUserUID(StringBuffer arg1);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OAuthAuthorizeTokenFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
