package io.fabric8.kubernetes.api.model.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class NonResourceRuleBuilder extends NonResourceRuleFluentImpl<NonResourceRuleBuilder> implements VisitableBuilder<NonResourceRule,NonResourceRuleBuilder>{

    NonResourceRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NonResourceRuleBuilder(){
            this(true);
    }
    public NonResourceRuleBuilder(Boolean validationEnabled){
            this(new NonResourceRule(), validationEnabled);
    }
    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent){
            this(fluent, true);
    }
    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NonResourceRule(), validationEnabled);
    }
    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,NonResourceRule instance){
            this(fluent, instance, true);
    }
    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,NonResourceRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
            fluent.withVerbs(instance.getVerbs()); 
            this.validationEnabled = validationEnabled; 
    }
    public NonResourceRuleBuilder(NonResourceRule instance){
            this(instance,true);
    }
    public NonResourceRuleBuilder(NonResourceRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNonResourceURLs(instance.getNonResourceURLs()); 
            this.withVerbs(instance.getVerbs()); 
            this.validationEnabled = validationEnabled; 
    }
    public NonResourceRuleBuilder(Validator validator){
            this(new NonResourceRule(), true);
    }
    public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,NonResourceRule instance,Validator validator){
            this.fluent = fluent; 
            fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
            fluent.withVerbs(instance.getVerbs()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public NonResourceRuleBuilder(NonResourceRule instance,Validator validator){
            this.fluent = this; 
            this.withNonResourceURLs(instance.getNonResourceURLs()); 
            this.withVerbs(instance.getVerbs()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public NonResourceRule build(){
            NonResourceRule buildable = new NonResourceRule(fluent.getNonResourceURLs(),fluent.getVerbs());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NonResourceRuleBuilder that = (NonResourceRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
