package io.fabric8.kubernetes.api.model.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ResourceRuleBuilder extends ResourceRuleFluentImpl<ResourceRuleBuilder> implements VisitableBuilder<ResourceRule,ResourceRuleBuilder>{

    ResourceRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ResourceRuleBuilder(){
            this(true);
    }
    public ResourceRuleBuilder(Boolean validationEnabled){
            this(new ResourceRule(), validationEnabled);
    }
    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent){
            this(fluent, true);
    }
    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ResourceRule(), validationEnabled);
    }
    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent,ResourceRule instance){
            this(fluent, instance, true);
    }
    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent,ResourceRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroups(instance.getApiGroups()); 
            fluent.withResourceNames(instance.getResourceNames()); 
            fluent.withResources(instance.getResources()); 
            fluent.withVerbs(instance.getVerbs()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceRuleBuilder(ResourceRule instance){
            this(instance,true);
    }
    public ResourceRuleBuilder(ResourceRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroups(instance.getApiGroups()); 
            this.withResourceNames(instance.getResourceNames()); 
            this.withResources(instance.getResources()); 
            this.withVerbs(instance.getVerbs()); 
            this.validationEnabled = validationEnabled; 
    }
    public ResourceRuleBuilder(Validator validator){
            this(new ResourceRule(), true);
    }
    public ResourceRuleBuilder(ResourceRuleFluent<?> fluent,ResourceRule instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiGroups(instance.getApiGroups()); 
            fluent.withResourceNames(instance.getResourceNames()); 
            fluent.withResources(instance.getResources()); 
            fluent.withVerbs(instance.getVerbs()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ResourceRuleBuilder(ResourceRule instance,Validator validator){
            this.fluent = this; 
            this.withApiGroups(instance.getApiGroups()); 
            this.withResourceNames(instance.getResourceNames()); 
            this.withResources(instance.getResources()); 
            this.withVerbs(instance.getVerbs()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ResourceRule build(){
            ResourceRule buildable = new ResourceRule(fluent.getApiGroups(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ResourceRuleBuilder that = (ResourceRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
