package io.fabric8.kubernetes.api.model.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SelfSubjectRulesReviewSpecBuilder extends SelfSubjectRulesReviewSpecFluentImpl<SelfSubjectRulesReviewSpecBuilder> implements VisitableBuilder<SelfSubjectRulesReviewSpec,SelfSubjectRulesReviewSpecBuilder>{

    SelfSubjectRulesReviewSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SelfSubjectRulesReviewSpecBuilder(){
            this(true);
    }
    public SelfSubjectRulesReviewSpecBuilder(Boolean validationEnabled){
            this(new SelfSubjectRulesReviewSpec(), validationEnabled);
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SelfSubjectRulesReviewSpec(), validationEnabled);
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance){
            this(fluent, instance, true);
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance){
            this(instance,true);
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public SelfSubjectRulesReviewSpecBuilder(Validator validator){
            this(new SelfSubjectRulesReviewSpec(), true);
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withNamespace(instance.getNamespace()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance,Validator validator){
            this.fluent = this; 
            this.withNamespace(instance.getNamespace()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SelfSubjectRulesReviewSpec build(){
            SelfSubjectRulesReviewSpec buildable = new SelfSubjectRulesReviewSpec(fluent.getNamespace());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SelfSubjectRulesReviewSpecBuilder that = (SelfSubjectRulesReviewSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
