package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface APIGroupFluent<A extends APIGroupFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildPreferredVersion instead.
 * @return The buildable object.
 */
@Deprecated public GroupVersionForDiscovery getPreferredVersion();
    public GroupVersionForDiscovery buildPreferredVersion();
    public A withPreferredVersion(GroupVersionForDiscovery preferredVersion);
    public Boolean hasPreferredVersion();
    public A withNewPreferredVersion(String groupVersion,String version);
    public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersion();
    public APIGroupFluent.PreferredVersionNested<A> withNewPreferredVersionLike(GroupVersionForDiscovery item);
    public APIGroupFluent.PreferredVersionNested<A> editPreferredVersion();
    public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersion();
    public APIGroupFluent.PreferredVersionNested<A> editOrNewPreferredVersionLike(GroupVersionForDiscovery item);
    public A addToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item);
    public A setToServerAddressByClientCIDRs(int index,ServerAddressByClientCIDR item);
    public A addToServerAddressByClientCIDRs(ServerAddressByClientCIDR... items);
    public A addAllToServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items);
    public A removeFromServerAddressByClientCIDRs(ServerAddressByClientCIDR... items);
    public A removeAllFromServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items);
    
/**
 * This method has been deprecated, please use method buildServerAddressByClientCIDRs instead.
 * @return The buildable object.
 */
@Deprecated public List<ServerAddressByClientCIDR> getServerAddressByClientCIDRs();
    public List<ServerAddressByClientCIDR> buildServerAddressByClientCIDRs();
    public ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index);
    public ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR();
    public ServerAddressByClientCIDR buildLastServerAddressByClientCIDR();
    public ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(io.fabric8.kubernetes.api.builder.Predicate<ServerAddressByClientCIDRBuilder> predicate);
    public Boolean hasMatchingServerAddressByClientCIDR(io.fabric8.kubernetes.api.builder.Predicate<ServerAddressByClientCIDRBuilder> predicate);
    public A withServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs);
    public A withServerAddressByClientCIDRs(ServerAddressByClientCIDR... serverAddressByClientCIDRs);
    public Boolean hasServerAddressByClientCIDRs();
    public A addNewServerAddressByClientCIDR(String clientCIDR,String serverAddress);
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR();
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(ServerAddressByClientCIDR item);
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index,ServerAddressByClientCIDR item);
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index);
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR();
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR();
    public APIGroupFluent.ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(io.fabric8.kubernetes.api.builder.Predicate<ServerAddressByClientCIDRBuilder> predicate);
    public A addToVersions(int index,GroupVersionForDiscovery item);
    public A setToVersions(int index,GroupVersionForDiscovery item);
    public A addToVersions(GroupVersionForDiscovery... items);
    public A addAllToVersions(Collection<GroupVersionForDiscovery> items);
    public A removeFromVersions(GroupVersionForDiscovery... items);
    public A removeAllFromVersions(Collection<GroupVersionForDiscovery> items);
    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<GroupVersionForDiscovery> getVersions();
    public List<GroupVersionForDiscovery> buildVersions();
    public GroupVersionForDiscovery buildVersion(int index);
    public GroupVersionForDiscovery buildFirstVersion();
    public GroupVersionForDiscovery buildLastVersion();
    public GroupVersionForDiscovery buildMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionForDiscoveryBuilder> predicate);
    public Boolean hasMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionForDiscoveryBuilder> predicate);
    public A withVersions(List<GroupVersionForDiscovery> versions);
    public A withVersions(GroupVersionForDiscovery... versions);
    public Boolean hasVersions();
    public A addNewVersion(String groupVersion,String version);
    public APIGroupFluent.VersionsNested<A> addNewVersion();
    public APIGroupFluent.VersionsNested<A> addNewVersionLike(GroupVersionForDiscovery item);
    public APIGroupFluent.VersionsNested<A> setNewVersionLike(int index,GroupVersionForDiscovery item);
    public APIGroupFluent.VersionsNested<A> editVersion(int index);
    public APIGroupFluent.VersionsNested<A> editFirstVersion();
    public APIGroupFluent.VersionsNested<A> editLastVersion();
    public APIGroupFluent.VersionsNested<A> editMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionForDiscoveryBuilder> predicate);

    public interface PreferredVersionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupVersionForDiscoveryFluent<APIGroupFluent.PreferredVersionNested<N>>{

        
    public N and();    public N endPreferredVersion();
}
    public interface ServerAddressByClientCIDRsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServerAddressByClientCIDRFluent<APIGroupFluent.ServerAddressByClientCIDRsNested<N>>{

        
    public N and();    public N endServerAddressByClientCIDR();
}
    public interface VersionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupVersionForDiscoveryFluent<APIGroupFluent.VersionsNested<N>>{

        
    public N and();    public N endVersion();
}


}
