package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class APIGroupListBuilder extends APIGroupListFluentImpl<APIGroupListBuilder> implements VisitableBuilder<APIGroupList,APIGroupListBuilder>{

    APIGroupListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public APIGroupListBuilder(){
            this(true);
    }
    public APIGroupListBuilder(Boolean validationEnabled){
            this(new APIGroupList(), validationEnabled);
    }
    public APIGroupListBuilder(APIGroupListFluent<?> fluent){
            this(fluent, true);
    }
    public APIGroupListBuilder(APIGroupListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new APIGroupList(), validationEnabled);
    }
    public APIGroupListBuilder(APIGroupListFluent<?> fluent,APIGroupList instance){
            this(fluent, instance, true);
    }
    public APIGroupListBuilder(APIGroupListFluent<?> fluent,APIGroupList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withGroups(instance.getGroups()); 
            fluent.withKind(instance.getKind()); 
            this.validationEnabled = validationEnabled; 
    }
    public APIGroupListBuilder(APIGroupList instance){
            this(instance,true);
    }
    public APIGroupListBuilder(APIGroupList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withGroups(instance.getGroups()); 
            this.withKind(instance.getKind()); 
            this.validationEnabled = validationEnabled; 
    }
    public APIGroupListBuilder(Validator validator){
            this(new APIGroupList(), true);
    }
    public APIGroupListBuilder(APIGroupListFluent<?> fluent,APIGroupList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withGroups(instance.getGroups()); 
            fluent.withKind(instance.getKind()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public APIGroupListBuilder(APIGroupList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withGroups(instance.getGroups()); 
            this.withKind(instance.getKind()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public APIGroupList build(){
            APIGroupList buildable = new APIGroupList(fluent.getApiVersion(),fluent.getGroups(),fluent.getKind());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            APIGroupListBuilder that = (APIGroupListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
