package io.fabric8.kubernetes.api.model.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SubjectRulesReviewStatusBuilder extends SubjectRulesReviewStatusFluentImpl<SubjectRulesReviewStatusBuilder> implements VisitableBuilder<SubjectRulesReviewStatus,SubjectRulesReviewStatusBuilder>{

    SubjectRulesReviewStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SubjectRulesReviewStatusBuilder(){
            this(true);
    }
    public SubjectRulesReviewStatusBuilder(Boolean validationEnabled){
            this(new SubjectRulesReviewStatus(), validationEnabled);
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubjectRulesReviewStatus(), validationEnabled);
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,SubjectRulesReviewStatus instance){
            this(fluent, instance, true);
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,SubjectRulesReviewStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEvaluationError(instance.getEvaluationError()); 
            fluent.withIncomplete(instance.getIncomplete()); 
            fluent.withNonResourceRules(instance.getNonResourceRules()); 
            fluent.withResourceRules(instance.getResourceRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatus instance){
            this(instance,true);
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEvaluationError(instance.getEvaluationError()); 
            this.withIncomplete(instance.getIncomplete()); 
            this.withNonResourceRules(instance.getNonResourceRules()); 
            this.withResourceRules(instance.getResourceRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubjectRulesReviewStatusBuilder(Validator validator){
            this(new SubjectRulesReviewStatus(), true);
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,SubjectRulesReviewStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withEvaluationError(instance.getEvaluationError()); 
            fluent.withIncomplete(instance.getIncomplete()); 
            fluent.withNonResourceRules(instance.getNonResourceRules()); 
            fluent.withResourceRules(instance.getResourceRules()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatus instance,Validator validator){
            this.fluent = this; 
            this.withEvaluationError(instance.getEvaluationError()); 
            this.withIncomplete(instance.getIncomplete()); 
            this.withNonResourceRules(instance.getNonResourceRules()); 
            this.withResourceRules(instance.getResourceRules()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SubjectRulesReviewStatus build(){
            SubjectRulesReviewStatus buildable = new SubjectRulesReviewStatus(fluent.getEvaluationError(),fluent.isIncomplete(),fluent.getNonResourceRules(),fluent.getResourceRules());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubjectRulesReviewStatusBuilder that = (SubjectRulesReviewStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
