/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl;

public class DeploymentStrategyBuilder
extends DeploymentStrategyFluentImpl<DeploymentStrategyBuilder>
implements VisitableBuilder<DeploymentStrategy, DeploymentStrategyBuilder> {
    DeploymentStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentStrategyBuilder() {
        this(true);
    }

    public DeploymentStrategyBuilder(Boolean validationEnabled) {
        this(new DeploymentStrategy(), validationEnabled);
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentStrategy(), validationEnabled);
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent, DeploymentStrategy instance) {
        this(fluent, instance, true);
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent, DeploymentStrategy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withCustomParams(instance.getCustomParams());
        fluent.withLabels(instance.getLabels());
        fluent.withRecreateParams(instance.getRecreateParams());
        fluent.withResources(instance.getResources());
        fluent.withRollingParams(instance.getRollingParams());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentStrategyBuilder(DeploymentStrategy instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentStrategyBuilder(DeploymentStrategy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAnnotations(instance.getAnnotations());
        this.withCustomParams(instance.getCustomParams());
        this.withLabels(instance.getLabels());
        this.withRecreateParams(instance.getRecreateParams());
        this.withResources(instance.getResources());
        this.withRollingParams(instance.getRollingParams());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DeploymentStrategy build() {
        DeploymentStrategy buildable = new DeploymentStrategy(this.fluent.getActiveDeadlineSeconds(), this.fluent.getAnnotations(), this.fluent.getCustomParams(), this.fluent.getLabels(), this.fluent.getRecreateParams(), this.fluent.getResources(), this.fluent.getRollingParams(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentStrategyBuilder that = (DeploymentStrategyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

