package io.fabric8.kubernetes.api.model.admissionregistration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ValidatingWebhookConfigurationFluentImpl<A extends ValidatingWebhookConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ValidatingWebhookConfigurationFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<ValidatingWebhookBuilder> webhooks;

    public ValidatingWebhookConfigurationFluentImpl(){
    }
    public ValidatingWebhookConfigurationFluentImpl(ValidatingWebhookConfiguration instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withWebhooks(instance.getWebhooks()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToWebhooks(int index,ValidatingWebhook item){
            if (this.webhooks == null) {this.webhooks = new ArrayList<ValidatingWebhookBuilder>();}
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(index >= 0 ? index : _visitables.get("webhooks").size(), builder);this.webhooks.add(index >= 0 ? index : webhooks.size(), builder); return (A)this;
    }

    public A setToWebhooks(int index,ValidatingWebhook item){
            if (this.webhooks == null) {this.webhooks = new ArrayList<ValidatingWebhookBuilder>();}
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            if (index < 0 || index >= _visitables.get("webhooks").size()) { _visitables.get("webhooks").add(builder); } else { _visitables.get("webhooks").set(index, builder);}
            if (index < 0 || index >= webhooks.size()) { webhooks.add(builder); } else { webhooks.set(index, builder);}
             return (A)this;
    }

    public A addToWebhooks(ValidatingWebhook... items){
            if (this.webhooks == null) {this.webhooks = new ArrayList<ValidatingWebhookBuilder>();}
            for (ValidatingWebhook item : items) {ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
    }

    public A addAllToWebhooks(Collection<ValidatingWebhook> items){
            if (this.webhooks == null) {this.webhooks = new ArrayList<ValidatingWebhookBuilder>();}
            for (ValidatingWebhook item : items) {ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
    }

    public A removeFromWebhooks(ValidatingWebhook... items){
            for (ValidatingWebhook item : items) {ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
    }

    public A removeAllFromWebhooks(Collection<ValidatingWebhook> items){
            for (ValidatingWebhook item : items) {ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildWebhooks instead.
 * @return The buildable object.
 */
@Deprecated public List<ValidatingWebhook> getWebhooks(){
            return build(webhooks);
    }

    public List<ValidatingWebhook> buildWebhooks(){
            return build(webhooks);
    }

    public ValidatingWebhook buildWebhook(int index){
            return this.webhooks.get(index).build();
    }

    public ValidatingWebhook buildFirstWebhook(){
            return this.webhooks.get(0).build();
    }

    public ValidatingWebhook buildLastWebhook(){
            return this.webhooks.get(webhooks.size() - 1).build();
    }

    public ValidatingWebhook buildMatchingWebhook(io.fabric8.kubernetes.api.builder.Predicate<ValidatingWebhookBuilder> predicate){
            for (ValidatingWebhookBuilder item: webhooks) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingWebhook(io.fabric8.kubernetes.api.builder.Predicate<ValidatingWebhookBuilder> predicate){
            for (ValidatingWebhookBuilder item: webhooks) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withWebhooks(List<ValidatingWebhook> webhooks){
            if (this.webhooks != null) { _visitables.get("webhooks").removeAll(this.webhooks);}
            if (webhooks != null) {this.webhooks = new ArrayList<ValidatingWebhookBuilder>(); for (ValidatingWebhook item : webhooks){this.addToWebhooks(item);}} else { this.webhooks = new ArrayList<ValidatingWebhookBuilder>();} return (A) this;
    }

    public A withWebhooks(ValidatingWebhook... webhooks){
            if (this.webhooks != null) {this.webhooks.clear();}
            if (webhooks != null) {for (ValidatingWebhook item :webhooks){ this.addToWebhooks(item);}} return (A) this;
    }

    public Boolean hasWebhooks(){
            return webhooks != null && !webhooks.isEmpty();
    }

    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook(){
            return new WebhooksNestedImpl();
    }

    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(ValidatingWebhook item){
            return new WebhooksNestedImpl(-1, item);
    }

    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(int index,ValidatingWebhook item){
            return new WebhooksNestedImpl(index, item);
    }

    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(int index){
            if (webhooks.size() <= index) throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
            return setNewWebhookLike(index, buildWebhook(index));
    }

    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook(){
            if (webhooks.size() == 0) throw new RuntimeException("Can't edit first webhooks. The list is empty.");
            return setNewWebhookLike(0, buildWebhook(0));
    }

    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook(){
            int index = webhooks.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last webhooks. The list is empty.");
            return setNewWebhookLike(index, buildWebhook(index));
    }

    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(io.fabric8.kubernetes.api.builder.Predicate<ValidatingWebhookBuilder> predicate){
            int index = -1;
            for (int i=0;i<webhooks.size();i++) { 
            if (predicate.apply(webhooks.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching webhooks. No match found.");
            return setNewWebhookLike(index, buildWebhook(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ValidatingWebhookConfigurationFluentImpl that = (ValidatingWebhookConfigurationFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (webhooks != null ? !webhooks.equals(that.webhooks) :that.webhooks != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ValidatingWebhookConfigurationFluent.MetadataNested<N>> implements ValidatingWebhookConfigurationFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ValidatingWebhookConfigurationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class WebhooksNestedImpl<N> extends ValidatingWebhookFluentImpl<ValidatingWebhookConfigurationFluent.WebhooksNested<N>> implements ValidatingWebhookConfigurationFluent.WebhooksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ValidatingWebhookBuilder builder;
        private final int index;
    
            WebhooksNestedImpl(int index,ValidatingWebhook item){
                    this.index = index;
                    this.builder = new ValidatingWebhookBuilder(this, item);
            }
            WebhooksNestedImpl(){
                    this.index = -1;
                    this.builder = new ValidatingWebhookBuilder(this);
            }
    
    public N and(){
            return (N) ValidatingWebhookConfigurationFluentImpl.this.setToWebhooks(index, builder.build());
    }
    public N endWebhook(){
            return and();
    }

}


}
