package io.fabric8.kubernetes.api.model.authorization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SubjectRulesReviewStatusFluent<A extends SubjectRulesReviewStatusFluent<A>> extends Fluent<A>{


    public String getEvaluationError();
    public A withEvaluationError(String evaluationError);
    public Boolean hasEvaluationError();
    public A withNewEvaluationError(String arg1);
    public A withNewEvaluationError(StringBuilder arg1);
    public A withNewEvaluationError(StringBuffer arg1);
    public Boolean isIncomplete();
    public A withIncomplete(Boolean incomplete);
    public Boolean hasIncomplete();
    public A withNewIncomplete(String arg1);
    public A withNewIncomplete(boolean arg1);
    public A addToNonResourceRules(int index,NonResourceRule item);
    public A setToNonResourceRules(int index,NonResourceRule item);
    public A addToNonResourceRules(NonResourceRule... items);
    public A addAllToNonResourceRules(Collection<NonResourceRule> items);
    public A removeFromNonResourceRules(NonResourceRule... items);
    public A removeAllFromNonResourceRules(Collection<NonResourceRule> items);
    
/**
 * This method has been deprecated, please use method buildNonResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<NonResourceRule> getNonResourceRules();
    public List<NonResourceRule> buildNonResourceRules();
    public NonResourceRule buildNonResourceRule(int index);
    public NonResourceRule buildFirstNonResourceRule();
    public NonResourceRule buildLastNonResourceRule();
    public NonResourceRule buildMatchingNonResourceRule(io.fabric8.kubernetes.api.builder.Predicate<NonResourceRuleBuilder> predicate);
    public Boolean hasMatchingNonResourceRule(io.fabric8.kubernetes.api.builder.Predicate<NonResourceRuleBuilder> predicate);
    public A withNonResourceRules(List<NonResourceRule> nonResourceRules);
    public A withNonResourceRules(NonResourceRule... nonResourceRules);
    public Boolean hasNonResourceRules();
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRule();
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRuleLike(NonResourceRule item);
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> setNewNonResourceRuleLike(int index,NonResourceRule item);
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editNonResourceRule(int index);
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editFirstNonResourceRule();
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editLastNonResourceRule();
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editMatchingNonResourceRule(io.fabric8.kubernetes.api.builder.Predicate<NonResourceRuleBuilder> predicate);
    public A addToResourceRules(int index,ResourceRule item);
    public A setToResourceRules(int index,ResourceRule item);
    public A addToResourceRules(ResourceRule... items);
    public A addAllToResourceRules(Collection<ResourceRule> items);
    public A removeFromResourceRules(ResourceRule... items);
    public A removeAllFromResourceRules(Collection<ResourceRule> items);
    
/**
 * This method has been deprecated, please use method buildResourceRules instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceRule> getResourceRules();
    public List<ResourceRule> buildResourceRules();
    public ResourceRule buildResourceRule(int index);
    public ResourceRule buildFirstResourceRule();
    public ResourceRule buildLastResourceRule();
    public ResourceRule buildMatchingResourceRule(io.fabric8.kubernetes.api.builder.Predicate<ResourceRuleBuilder> predicate);
    public Boolean hasMatchingResourceRule(io.fabric8.kubernetes.api.builder.Predicate<ResourceRuleBuilder> predicate);
    public A withResourceRules(List<ResourceRule> resourceRules);
    public A withResourceRules(ResourceRule... resourceRules);
    public Boolean hasResourceRules();
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRule();
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRuleLike(ResourceRule item);
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> setNewResourceRuleLike(int index,ResourceRule item);
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editResourceRule(int index);
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editFirstResourceRule();
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editLastResourceRule();
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editMatchingResourceRule(io.fabric8.kubernetes.api.builder.Predicate<ResourceRuleBuilder> predicate);

    public interface NonResourceRulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NonResourceRuleFluent<SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>>{

        
    public N and();    public N endNonResourceRule();
}
    public interface ResourceRulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRuleFluent<SubjectRulesReviewStatusFluent.ResourceRulesNested<N>>{

        
    public N and();    public N endResourceRule();
}


}
