package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class WindowsSecurityContextOptionsBuilder extends WindowsSecurityContextOptionsFluentImpl<WindowsSecurityContextOptionsBuilder> implements VisitableBuilder<WindowsSecurityContextOptions,WindowsSecurityContextOptionsBuilder>{

    WindowsSecurityContextOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public WindowsSecurityContextOptionsBuilder(){
            this(true);
    }
    public WindowsSecurityContextOptionsBuilder(Boolean validationEnabled){
            this(new WindowsSecurityContextOptions(), validationEnabled);
    }
    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new WindowsSecurityContextOptions(), validationEnabled);
    }
    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent,WindowsSecurityContextOptions instance){
            this(fluent, instance, true);
    }
    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptionsFluent<?> fluent,WindowsSecurityContextOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGmsaCredentialSpec(instance.getGmsaCredentialSpec()); 
            fluent.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName()); 
            fluent.withRunAsUserName(instance.getRunAsUserName()); 
            this.validationEnabled = validationEnabled; 
    }
    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptions instance){
            this(instance,true);
    }
    public WindowsSecurityContextOptionsBuilder(WindowsSecurityContextOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGmsaCredentialSpec(instance.getGmsaCredentialSpec()); 
            this.withGmsaCredentialSpecName(instance.getGmsaCredentialSpecName()); 
            this.withRunAsUserName(instance.getRunAsUserName()); 
            this.validationEnabled = validationEnabled; 
    }

    public WindowsSecurityContextOptions build(){
            WindowsSecurityContextOptions buildable = new WindowsSecurityContextOptions(fluent.getGmsaCredentialSpec(),fluent.getGmsaCredentialSpecName(),fluent.getRunAsUserName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            WindowsSecurityContextOptionsBuilder that = (WindowsSecurityContextOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
