package io.fabric8.kubernetes.api.model.coordination.v1beta1;

import io.fabric8.kubernetes.api.model.MicroTimeFluentImpl;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.MicroTimeBuilder;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class LeaseSpecFluentImpl<A extends LeaseSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LeaseSpecFluent<A>{

    private MicroTimeBuilder acquireTime;
    private String holderIdentity;
    private Integer leaseDurationSeconds;
    private Integer leaseTransitions;
    private MicroTimeBuilder renewTime;

    public LeaseSpecFluentImpl(){
    }
    public LeaseSpecFluentImpl(LeaseSpec instance){
            this.withAcquireTime(instance.getAcquireTime()); 
            this.withHolderIdentity(instance.getHolderIdentity()); 
            this.withLeaseDurationSeconds(instance.getLeaseDurationSeconds()); 
            this.withLeaseTransitions(instance.getLeaseTransitions()); 
            this.withRenewTime(instance.getRenewTime()); 
    }

    
/**
 * This method has been deprecated, please use method buildAcquireTime instead.
 * @return The buildable object.
 */
@Deprecated public MicroTime getAcquireTime(){
            return this.acquireTime!=null?this.acquireTime.build():null;
    }

    public MicroTime buildAcquireTime(){
            return this.acquireTime!=null?this.acquireTime.build():null;
    }

    public A withAcquireTime(MicroTime acquireTime){
            _visitables.get("acquireTime").remove(this.acquireTime);
            if (acquireTime!=null){ this.acquireTime= new MicroTimeBuilder(acquireTime); _visitables.get("acquireTime").add(this.acquireTime);} return (A) this;
    }

    public Boolean hasAcquireTime(){
            return this.acquireTime != null;
    }

    public A withNewAcquireTime(String time){
            return (A)withAcquireTime(new MicroTime(time));
    }

    public LeaseSpecFluent.AcquireTimeNested<A> withNewAcquireTime(){
            return new AcquireTimeNestedImpl();
    }

    public LeaseSpecFluent.AcquireTimeNested<A> withNewAcquireTimeLike(MicroTime item){
            return new AcquireTimeNestedImpl(item);
    }

    public LeaseSpecFluent.AcquireTimeNested<A> editAcquireTime(){
            return withNewAcquireTimeLike(getAcquireTime());
    }

    public LeaseSpecFluent.AcquireTimeNested<A> editOrNewAcquireTime(){
            return withNewAcquireTimeLike(getAcquireTime() != null ? getAcquireTime(): new MicroTimeBuilder().build());
    }

    public LeaseSpecFluent.AcquireTimeNested<A> editOrNewAcquireTimeLike(MicroTime item){
            return withNewAcquireTimeLike(getAcquireTime() != null ? getAcquireTime(): item);
    }

    public String getHolderIdentity(){
            return this.holderIdentity;
    }

    public A withHolderIdentity(String holderIdentity){
            this.holderIdentity=holderIdentity; return (A) this;
    }

    public Boolean hasHolderIdentity(){
            return this.holderIdentity != null;
    }

    public A withNewHolderIdentity(String arg1){
            return (A)withHolderIdentity(new String(arg1));
    }

    public A withNewHolderIdentity(StringBuilder arg1){
            return (A)withHolderIdentity(new String(arg1));
    }

    public A withNewHolderIdentity(StringBuffer arg1){
            return (A)withHolderIdentity(new String(arg1));
    }

    public Integer getLeaseDurationSeconds(){
            return this.leaseDurationSeconds;
    }

    public A withLeaseDurationSeconds(Integer leaseDurationSeconds){
            this.leaseDurationSeconds=leaseDurationSeconds; return (A) this;
    }

    public Boolean hasLeaseDurationSeconds(){
            return this.leaseDurationSeconds != null;
    }

    public Integer getLeaseTransitions(){
            return this.leaseTransitions;
    }

    public A withLeaseTransitions(Integer leaseTransitions){
            this.leaseTransitions=leaseTransitions; return (A) this;
    }

    public Boolean hasLeaseTransitions(){
            return this.leaseTransitions != null;
    }

    
/**
 * This method has been deprecated, please use method buildRenewTime instead.
 * @return The buildable object.
 */
@Deprecated public MicroTime getRenewTime(){
            return this.renewTime!=null?this.renewTime.build():null;
    }

    public MicroTime buildRenewTime(){
            return this.renewTime!=null?this.renewTime.build():null;
    }

    public A withRenewTime(MicroTime renewTime){
            _visitables.get("renewTime").remove(this.renewTime);
            if (renewTime!=null){ this.renewTime= new MicroTimeBuilder(renewTime); _visitables.get("renewTime").add(this.renewTime);} return (A) this;
    }

    public Boolean hasRenewTime(){
            return this.renewTime != null;
    }

    public A withNewRenewTime(String time){
            return (A)withRenewTime(new MicroTime(time));
    }

    public LeaseSpecFluent.RenewTimeNested<A> withNewRenewTime(){
            return new RenewTimeNestedImpl();
    }

    public LeaseSpecFluent.RenewTimeNested<A> withNewRenewTimeLike(MicroTime item){
            return new RenewTimeNestedImpl(item);
    }

    public LeaseSpecFluent.RenewTimeNested<A> editRenewTime(){
            return withNewRenewTimeLike(getRenewTime());
    }

    public LeaseSpecFluent.RenewTimeNested<A> editOrNewRenewTime(){
            return withNewRenewTimeLike(getRenewTime() != null ? getRenewTime(): new MicroTimeBuilder().build());
    }

    public LeaseSpecFluent.RenewTimeNested<A> editOrNewRenewTimeLike(MicroTime item){
            return withNewRenewTimeLike(getRenewTime() != null ? getRenewTime(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LeaseSpecFluentImpl that = (LeaseSpecFluentImpl) o;
            if (acquireTime != null ? !acquireTime.equals(that.acquireTime) :that.acquireTime != null) return false;
            if (holderIdentity != null ? !holderIdentity.equals(that.holderIdentity) :that.holderIdentity != null) return false;
            if (leaseDurationSeconds != null ? !leaseDurationSeconds.equals(that.leaseDurationSeconds) :that.leaseDurationSeconds != null) return false;
            if (leaseTransitions != null ? !leaseTransitions.equals(that.leaseTransitions) :that.leaseTransitions != null) return false;
            if (renewTime != null ? !renewTime.equals(that.renewTime) :that.renewTime != null) return false;
            return true;
    }


    public class AcquireTimeNestedImpl<N> extends MicroTimeFluentImpl<LeaseSpecFluent.AcquireTimeNested<N>> implements LeaseSpecFluent.AcquireTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final MicroTimeBuilder builder;
    
            AcquireTimeNestedImpl(MicroTime item){
                    this.builder = new MicroTimeBuilder(this, item);
            }
            AcquireTimeNestedImpl(){
                    this.builder = new MicroTimeBuilder(this);
            }
    
    public N and(){
            return (N) LeaseSpecFluentImpl.this.withAcquireTime(builder.build());
    }
    public N endAcquireTime(){
            return and();
    }

}
    public class RenewTimeNestedImpl<N> extends MicroTimeFluentImpl<LeaseSpecFluent.RenewTimeNested<N>> implements LeaseSpecFluent.RenewTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final MicroTimeBuilder builder;
    
            RenewTimeNestedImpl(MicroTime item){
                    this.builder = new MicroTimeBuilder(this, item);
            }
            RenewTimeNestedImpl(){
                    this.builder = new MicroTimeBuilder(this);
            }
    
    public N and(){
            return (N) LeaseSpecFluentImpl.this.withRenewTime(builder.build());
    }
    public N endRenewTime(){
            return and();
    }

}


}
