package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerMetricsBuilder extends ContainerMetricsFluentImpl<ContainerMetricsBuilder> implements VisitableBuilder<ContainerMetrics,ContainerMetricsBuilder>{

    ContainerMetricsFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerMetricsBuilder(){
            this(true);
    }
    public ContainerMetricsBuilder(Boolean validationEnabled){
            this(new ContainerMetrics(), validationEnabled);
    }
    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerMetrics(), validationEnabled);
    }
    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent,ContainerMetrics instance){
            this(fluent, instance, true);
    }
    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent,ContainerMetrics instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withUsage(instance.getUsage()); 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerMetricsBuilder(ContainerMetrics instance){
            this(instance,true);
    }
    public ContainerMetricsBuilder(ContainerMetrics instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withUsage(instance.getUsage()); 
            this.validationEnabled = validationEnabled; 
    }

    public ContainerMetrics build(){
            ContainerMetrics buildable = new ContainerMetrics(fluent.getName(),fluent.getUsage());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerMetricsBuilder that = (ContainerMetricsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
