package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class DurationFluentImpl<A extends DurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DurationFluent<A>{

    private Long duration;

    public DurationFluentImpl(){
    }
    public DurationFluentImpl(Duration instance){
            this.withDuration(instance.getDuration()); 
    }

    public Long getDuration(){
            return this.duration;
    }

    public A withDuration(Long duration){
            this.duration=duration; return (A) this;
    }

    public Boolean hasDuration(){
            return this.duration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DurationFluentImpl that = (DurationFluentImpl) o;
            if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
            return true;
    }




}
