package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodsMetricSourceBuilder extends PodsMetricSourceFluentImpl<PodsMetricSourceBuilder> implements VisitableBuilder<PodsMetricSource,PodsMetricSourceBuilder>{

    PodsMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public PodsMetricSourceBuilder(){
            this(true);
    }
    public PodsMetricSourceBuilder(Boolean validationEnabled){
            this(new PodsMetricSource(), validationEnabled);
    }
    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent){
            this(fluent, true);
    }
    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PodsMetricSource(), validationEnabled);
    }
    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,PodsMetricSource instance){
            this(fluent, instance, true);
    }
    public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,PodsMetricSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetricName(instance.getMetricName()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withTargetAverageValue(instance.getTargetAverageValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public PodsMetricSourceBuilder(PodsMetricSource instance){
            this(instance,true);
    }
    public PodsMetricSourceBuilder(PodsMetricSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetricName(instance.getMetricName()); 
            this.withSelector(instance.getSelector()); 
            this.withTargetAverageValue(instance.getTargetAverageValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public PodsMetricSource build(){
            PodsMetricSource buildable = new PodsMetricSource(fluent.getMetricName(),fluent.getSelector(),fluent.getTargetAverageValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodsMetricSourceBuilder that = (PodsMetricSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
