package io.fabric8.kubernetes.api.model.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentSourceFluentImpl<A extends VolumeAttachmentSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VolumeAttachmentSourceFluent<A>{

    private PersistentVolumeSpecBuilder inlineVolumeSpec;
    private String persistentVolumeName;

    public VolumeAttachmentSourceFluentImpl(){
    }
    public VolumeAttachmentSourceFluentImpl(VolumeAttachmentSource instance){
            this.withInlineVolumeSpec(instance.getInlineVolumeSpec()); 
            this.withPersistentVolumeName(instance.getPersistentVolumeName()); 
    }

    
/**
 * This method has been deprecated, please use method buildInlineVolumeSpec instead.
 * @return The buildable object.
 */
@Deprecated public PersistentVolumeSpec getInlineVolumeSpec(){
            return this.inlineVolumeSpec!=null?this.inlineVolumeSpec.build():null;
    }

    public PersistentVolumeSpec buildInlineVolumeSpec(){
            return this.inlineVolumeSpec!=null?this.inlineVolumeSpec.build():null;
    }

    public A withInlineVolumeSpec(PersistentVolumeSpec inlineVolumeSpec){
            _visitables.get("inlineVolumeSpec").remove(this.inlineVolumeSpec);
            if (inlineVolumeSpec!=null){ this.inlineVolumeSpec= new PersistentVolumeSpecBuilder(inlineVolumeSpec); _visitables.get("inlineVolumeSpec").add(this.inlineVolumeSpec);} return (A) this;
    }

    public Boolean hasInlineVolumeSpec(){
            return this.inlineVolumeSpec != null;
    }

    public VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> withNewInlineVolumeSpec(){
            return new InlineVolumeSpecNestedImpl();
    }

    public VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> withNewInlineVolumeSpecLike(PersistentVolumeSpec item){
            return new InlineVolumeSpecNestedImpl(item);
    }

    public VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> editInlineVolumeSpec(){
            return withNewInlineVolumeSpecLike(getInlineVolumeSpec());
    }

    public VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> editOrNewInlineVolumeSpec(){
            return withNewInlineVolumeSpecLike(getInlineVolumeSpec() != null ? getInlineVolumeSpec(): new PersistentVolumeSpecBuilder().build());
    }

    public VolumeAttachmentSourceFluent.InlineVolumeSpecNested<A> editOrNewInlineVolumeSpecLike(PersistentVolumeSpec item){
            return withNewInlineVolumeSpecLike(getInlineVolumeSpec() != null ? getInlineVolumeSpec(): item);
    }

    public String getPersistentVolumeName(){
            return this.persistentVolumeName;
    }

    public A withPersistentVolumeName(String persistentVolumeName){
            this.persistentVolumeName=persistentVolumeName; return (A) this;
    }

    public Boolean hasPersistentVolumeName(){
            return this.persistentVolumeName != null;
    }

    public A withNewPersistentVolumeName(String arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public A withNewPersistentVolumeName(StringBuilder arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public A withNewPersistentVolumeName(StringBuffer arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            VolumeAttachmentSourceFluentImpl that = (VolumeAttachmentSourceFluentImpl) o;
            if (inlineVolumeSpec != null ? !inlineVolumeSpec.equals(that.inlineVolumeSpec) :that.inlineVolumeSpec != null) return false;
            if (persistentVolumeName != null ? !persistentVolumeName.equals(that.persistentVolumeName) :that.persistentVolumeName != null) return false;
            return true;
    }


    public class InlineVolumeSpecNestedImpl<N> extends PersistentVolumeSpecFluentImpl<VolumeAttachmentSourceFluent.InlineVolumeSpecNested<N>> implements VolumeAttachmentSourceFluent.InlineVolumeSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeSpecBuilder builder;
    
            InlineVolumeSpecNestedImpl(PersistentVolumeSpec item){
                    this.builder = new PersistentVolumeSpecBuilder(this, item);
            }
            InlineVolumeSpecNestedImpl(){
                    this.builder = new PersistentVolumeSpecBuilder(this);
            }
    
    public N and(){
            return (N) VolumeAttachmentSourceFluentImpl.this.withInlineVolumeSpec(builder.build());
    }
    public N endInlineVolumeSpec(){
            return and();
    }

}


}
