package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class CSIVolumeSourceFluentImpl<A extends CSIVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CSIVolumeSourceFluent<A>{

    private String driver;
    private String fsType;
    private LocalObjectReferenceBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String,String> volumeAttributes;

    public CSIVolumeSourceFluentImpl(){
    }
    public CSIVolumeSourceFluentImpl(CSIVolumeSource instance){
            this.withDriver(instance.getDriver()); 
            this.withFsType(instance.getFsType()); 
            this.withNodePublishSecretRef(instance.getNodePublishSecretRef()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withVolumeAttributes(instance.getVolumeAttributes()); 
    }

    public String getDriver(){
            return this.driver;
    }

    public A withDriver(String driver){
            this.driver=driver; return (A) this;
    }

    public Boolean hasDriver(){
            return this.driver != null;
    }

    public A withNewDriver(String arg1){
            return (A)withDriver(new String(arg1));
    }

    public A withNewDriver(StringBuilder arg1){
            return (A)withDriver(new String(arg1));
    }

    public A withNewDriver(StringBuffer arg1){
            return (A)withDriver(new String(arg1));
    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType != null;
    }

    public A withNewFsType(String arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuilder arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1){
            return (A)withFsType(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNodePublishSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getNodePublishSecretRef(){
            return this.nodePublishSecretRef!=null?this.nodePublishSecretRef.build():null;
    }

    public LocalObjectReference buildNodePublishSecretRef(){
            return this.nodePublishSecretRef!=null?this.nodePublishSecretRef.build():null;
    }

    public A withNodePublishSecretRef(LocalObjectReference nodePublishSecretRef){
            _visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
            if (nodePublishSecretRef!=null){ this.nodePublishSecretRef= new LocalObjectReferenceBuilder(nodePublishSecretRef); _visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);} return (A) this;
    }

    public Boolean hasNodePublishSecretRef(){
            return this.nodePublishSecretRef != null;
    }

    public A withNewNodePublishSecretRef(String name){
            return (A)withNodePublishSecretRef(new LocalObjectReference(name));
    }

    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef(){
            return new NodePublishSecretRefNestedImpl();
    }

    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(LocalObjectReference item){
            return new NodePublishSecretRefNestedImpl(item);
    }

    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef(){
            return withNewNodePublishSecretRefLike(getNodePublishSecretRef());
    }

    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef(){
            return withNewNodePublishSecretRefLike(getNodePublishSecretRef() != null ? getNodePublishSecretRef(): new LocalObjectReferenceBuilder().build());
    }

    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(LocalObjectReference item){
            return withNewNodePublishSecretRefLike(getNodePublishSecretRef() != null ? getNodePublishSecretRef(): item);
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A addToVolumeAttributes(String key,String value){
            if(this.volumeAttributes == null && key != null && value != null) { this.volumeAttributes = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.volumeAttributes.put(key, value);} return (A)this;
    }

    public A addToVolumeAttributes(Map<String,String> map){
            if(this.volumeAttributes == null && map != null) { this.volumeAttributes = new LinkedHashMap<String,String>(); }
            if(map != null) { this.volumeAttributes.putAll(map);} return (A)this;
    }

    public A removeFromVolumeAttributes(String key){
            if(this.volumeAttributes == null) { return (A) this; }
            if(key != null && this.volumeAttributes != null) {this.volumeAttributes.remove(key);} return (A)this;
    }

    public A removeFromVolumeAttributes(Map<String,String> map){
            if(this.volumeAttributes == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.volumeAttributes != null){this.volumeAttributes.remove(key);}}} return (A)this;
    }

    public Map<String,String> getVolumeAttributes(){
            return this.volumeAttributes;
    }

    public A withVolumeAttributes(Map<String,String> volumeAttributes){
            if (volumeAttributes == null) { this.volumeAttributes =  null;} else {this.volumeAttributes = new LinkedHashMap<String,String>(volumeAttributes);} return (A) this;
    }

    public Boolean hasVolumeAttributes(){
            return this.volumeAttributes != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CSIVolumeSourceFluentImpl that = (CSIVolumeSourceFluentImpl) o;
            if (driver != null ? !driver.equals(that.driver) :that.driver != null) return false;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (nodePublishSecretRef != null ? !nodePublishSecretRef.equals(that.nodePublishSecretRef) :that.nodePublishSecretRef != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (volumeAttributes != null ? !volumeAttributes.equals(that.volumeAttributes) :that.volumeAttributes != null) return false;
            return true;
    }


    public class NodePublishSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<CSIVolumeSourceFluent.NodePublishSecretRefNested<N>> implements CSIVolumeSourceFluent.NodePublishSecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            NodePublishSecretRefNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
            NodePublishSecretRefNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) CSIVolumeSourceFluentImpl.this.withNodePublishSecretRef(builder.build());
    }
    public N endNodePublishSecretRef(){
            return and();
    }

}


}
