package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class ContainerMetricsFluentImpl<A extends ContainerMetricsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContainerMetricsFluent<A>{

    private String name;
    private Map<String,Quantity> usage;

    public ContainerMetricsFluentImpl(){
    }
    public ContainerMetricsFluentImpl(ContainerMetrics instance){
            this.withName(instance.getName()); 
            this.withUsage(instance.getUsage()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToUsage(String key,Quantity value){
            if(this.usage == null && key != null && value != null) { this.usage = new LinkedHashMap<String,Quantity>(); }
            if(key != null && value != null) {this.usage.put(key, value);} return (A)this;
    }

    public A addToUsage(Map<String,Quantity> map){
            if(this.usage == null && map != null) { this.usage = new LinkedHashMap<String,Quantity>(); }
            if(map != null) { this.usage.putAll(map);} return (A)this;
    }

    public A removeFromUsage(String key){
            if(this.usage == null) { return (A) this; }
            if(key != null && this.usage != null) {this.usage.remove(key);} return (A)this;
    }

    public A removeFromUsage(Map<String,Quantity> map){
            if(this.usage == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.usage != null){this.usage.remove(key);}}} return (A)this;
    }

    public Map<String,Quantity> getUsage(){
            return this.usage;
    }

    public A withUsage(Map<String,Quantity> usage){
            if (usage == null) { this.usage =  null;} else {this.usage = new LinkedHashMap<String,Quantity>(usage);} return (A) this;
    }

    public Boolean hasUsage(){
            return this.usage != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ContainerMetricsFluentImpl that = (ContainerMetricsFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (usage != null ? !usage.equals(that.usage) :that.usage != null) return false;
            return true;
    }




}
