package io.fabric8.kubernetes.api.model.authorization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ResourceRuleFluent<A extends ResourceRuleFluent<A>> extends Fluent<A>{


    public A addToApiGroups(int index,String item);
    public A setToApiGroups(int index,String item);
    public A addToApiGroups(String... items);
    public A addAllToApiGroups(Collection<String> items);
    public A removeFromApiGroups(String... items);
    public A removeAllFromApiGroups(Collection<String> items);
    public List<String> getApiGroups();
    public String getApiGroup(int index);
    public String getFirstApiGroup();
    public String getLastApiGroup();
    public String getMatchingApiGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingApiGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withApiGroups(List<String> apiGroups);
    public A withApiGroups(String... apiGroups);
    public Boolean hasApiGroups();
    public A addNewApiGroup(String arg1);
    public A addNewApiGroup(StringBuilder arg1);
    public A addNewApiGroup(StringBuffer arg1);
    public A addToResourceNames(int index,String item);
    public A setToResourceNames(int index,String item);
    public A addToResourceNames(String... items);
    public A addAllToResourceNames(Collection<String> items);
    public A removeFromResourceNames(String... items);
    public A removeAllFromResourceNames(Collection<String> items);
    public List<String> getResourceNames();
    public String getResourceName(int index);
    public String getFirstResourceName();
    public String getLastResourceName();
    public String getMatchingResourceName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingResourceName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withResourceNames(List<String> resourceNames);
    public A withResourceNames(String... resourceNames);
    public Boolean hasResourceNames();
    public A addNewResourceName(String arg1);
    public A addNewResourceName(StringBuilder arg1);
    public A addNewResourceName(StringBuffer arg1);
    public A addToResources(int index,String item);
    public A setToResources(int index,String item);
    public A addToResources(String... items);
    public A addAllToResources(Collection<String> items);
    public A removeFromResources(String... items);
    public A removeAllFromResources(Collection<String> items);
    public List<String> getResources();
    public String getResource(int index);
    public String getFirstResource();
    public String getLastResource();
    public String getMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withResources(List<String> resources);
    public A withResources(String... resources);
    public Boolean hasResources();
    public A addNewResource(String arg1);
    public A addNewResource(StringBuilder arg1);
    public A addNewResource(StringBuffer arg1);
    public A addToVerbs(int index,String item);
    public A setToVerbs(int index,String item);
    public A addToVerbs(String... items);
    public A addAllToVerbs(Collection<String> items);
    public A removeFromVerbs(String... items);
    public A removeAllFromVerbs(Collection<String> items);
    public List<String> getVerbs();
    public String getVerb(int index);
    public String getFirstVerb();
    public String getLastVerb();
    public String getMatchingVerb(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingVerb(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withVerbs(List<String> verbs);
    public A withVerbs(String... verbs);
    public Boolean hasVerbs();
    public A addNewVerb(String arg1);
    public A addNewVerb(StringBuilder arg1);
    public A addNewVerb(StringBuffer arg1);



}
