package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

public interface MetricValueStatusFluent<A extends MetricValueStatusFluent<A>> extends Fluent<A>{


    public Integer getAverageUtilization();
    public A withAverageUtilization(Integer averageUtilization);
    public Boolean hasAverageUtilization();
    
/**
 * This method has been deprecated, please use method buildAverageValue instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getAverageValue();
    public Quantity buildAverageValue();
    public A withAverageValue(Quantity averageValue);
    public Boolean hasAverageValue();
    public A withNewAverageValue(String amount,String format);
    public A withNewAverageValue(String amount);
    public MetricValueStatusFluent.AverageValueNested<A> withNewAverageValue();
    public MetricValueStatusFluent.AverageValueNested<A> withNewAverageValueLike(Quantity item);
    public MetricValueStatusFluent.AverageValueNested<A> editAverageValue();
    public MetricValueStatusFluent.AverageValueNested<A> editOrNewAverageValue();
    public MetricValueStatusFluent.AverageValueNested<A> editOrNewAverageValueLike(Quantity item);
    
/**
 * This method has been deprecated, please use method buildValue instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getValue();
    public Quantity buildValue();
    public A withValue(Quantity value);
    public Boolean hasValue();
    public A withNewValue(String amount,String format);
    public A withNewValue(String amount);
    public MetricValueStatusFluent.ValueNested<A> withNewValue();
    public MetricValueStatusFluent.ValueNested<A> withNewValueLike(Quantity item);
    public MetricValueStatusFluent.ValueNested<A> editValue();
    public MetricValueStatusFluent.ValueNested<A> editOrNewValue();
    public MetricValueStatusFluent.ValueNested<A> editOrNewValueLike(Quantity item);

    public interface AverageValueNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuantityFluent<MetricValueStatusFluent.AverageValueNested<N>>{

        
    public N and();    public N endAverageValue();
}
    public interface ValueNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuantityFluent<MetricValueStatusFluent.ValueNested<N>>{

        
    public N and();    public N endValue();
}


}
