package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class UpdateFluentImpl<A extends UpdateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements UpdateFluent<A>{

    private Boolean force;
    private String image;
    private String version;

    public UpdateFluentImpl(){
    }
    public UpdateFluentImpl(Update instance){
            this.withForce(instance.getForce()); 
            this.withImage(instance.getImage()); 
            this.withVersion(instance.getVersion()); 
    }

    public Boolean isForce(){
            return this.force;
    }

    public A withForce(Boolean force){
            this.force=force; return (A) this;
    }

    public Boolean hasForce(){
            return this.force != null;
    }

    public A withNewForce(String arg1){
            return (A)withForce(new Boolean(arg1));
    }

    public A withNewForce(boolean arg1){
            return (A)withForce(new Boolean(arg1));
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public String getVersion(){
            return this.version;
    }

    public A withVersion(String version){
            this.version=version; return (A) this;
    }

    public Boolean hasVersion(){
            return this.version != null;
    }

    public A withNewVersion(String arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1){
            return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            UpdateFluentImpl that = (UpdateFluentImpl) o;
            if (force != null ? !force.equals(that.force) :that.force != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (version != null ? !version.equals(that.version) :that.version != null) return false;
            return true;
    }




}
