package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricTargetBuilder extends MetricTargetFluentImpl<MetricTargetBuilder> implements VisitableBuilder<MetricTarget,MetricTargetBuilder>{

    MetricTargetFluent<?> fluent;
    Boolean validationEnabled;

    public MetricTargetBuilder(){
            this(true);
    }
    public MetricTargetBuilder(Boolean validationEnabled){
            this(new MetricTarget(), validationEnabled);
    }
    public MetricTargetBuilder(MetricTargetFluent<?> fluent){
            this(fluent, true);
    }
    public MetricTargetBuilder(MetricTargetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricTarget(), validationEnabled);
    }
    public MetricTargetBuilder(MetricTargetFluent<?> fluent,MetricTarget instance){
            this(fluent, instance, true);
    }
    public MetricTargetBuilder(MetricTargetFluent<?> fluent,MetricTarget instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAverageUtilization(instance.getAverageUtilization()); 
            fluent.withAverageValue(instance.getAverageValue()); 
            fluent.withType(instance.getType()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricTargetBuilder(MetricTarget instance){
            this(instance,true);
    }
    public MetricTargetBuilder(MetricTarget instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAverageUtilization(instance.getAverageUtilization()); 
            this.withAverageValue(instance.getAverageValue()); 
            this.withType(instance.getType()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public MetricTarget build(){
            MetricTarget buildable = new MetricTarget(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getType(),fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricTargetBuilder that = (MetricTargetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
