/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesResource;
import io.fabric8.kubernetes.api.model.v4_0.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.v4_0.NamedCluster;
import io.fabric8.kubernetes.api.model.v4_0.NamedContext;
import io.fabric8.kubernetes.api.model.v4_0.NamedExtension;
import io.fabric8.kubernetes.api.model.v4_0.Preferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "clusters", "contexts", "current-context", "extensions", "preferences", "users"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Config
implements KubernetesResource {
    @JsonProperty(value="apiVersion")
    private String apiVersion;
    @JsonProperty(value="clusters")
    @Valid
    private List<NamedCluster> clusters = new ArrayList<NamedCluster>();
    @JsonProperty(value="contexts")
    @Valid
    private List<NamedContext> contexts = new ArrayList<NamedContext>();
    @JsonProperty(value="current-context")
    private String currentContext;
    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<NamedExtension> extensions = new ArrayList<NamedExtension>();
    @JsonProperty(value="kind")
    private String kind;
    @JsonProperty(value="preferences")
    @Valid
    private Preferences preferences;
    @JsonProperty(value="users")
    @Valid
    private List<NamedAuthInfo> users = new ArrayList<NamedAuthInfo>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Config() {
    }

    public Config(String apiVersion, List<NamedCluster> clusters, List<NamedContext> contexts, String currentContext, List<NamedExtension> extensions, String kind, Preferences preferences, List<NamedAuthInfo> users) {
        this.apiVersion = apiVersion;
        this.clusters = clusters;
        this.contexts = contexts;
        this.currentContext = currentContext;
        this.extensions = extensions;
        this.kind = kind;
        this.preferences = preferences;
        this.users = users;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="clusters")
    public List<NamedCluster> getClusters() {
        return this.clusters;
    }

    @JsonProperty(value="clusters")
    public void setClusters(List<NamedCluster> clusters) {
        this.clusters = clusters;
    }

    @JsonProperty(value="contexts")
    public List<NamedContext> getContexts() {
        return this.contexts;
    }

    @JsonProperty(value="contexts")
    public void setContexts(List<NamedContext> contexts) {
        this.contexts = contexts;
    }

    @JsonProperty(value="current-context")
    public String getCurrentContext() {
        return this.currentContext;
    }

    @JsonProperty(value="current-context")
    public void setCurrentContext(String currentContext) {
        this.currentContext = currentContext;
    }

    @JsonProperty(value="extensions")
    public List<NamedExtension> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(List<NamedExtension> extensions) {
        this.extensions = extensions;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="preferences")
    public Preferences getPreferences() {
        return this.preferences;
    }

    @JsonProperty(value="preferences")
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @JsonProperty(value="users")
    public List<NamedAuthInfo> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<NamedAuthInfo> users) {
        this.users = users;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Config(apiVersion=" + this.getApiVersion() + ", clusters=" + this.getClusters() + ", contexts=" + this.getContexts() + ", currentContext=" + this.getCurrentContext() + ", extensions=" + this.getExtensions() + ", kind=" + this.getKind() + ", preferences=" + this.getPreferences() + ", users=" + this.getUsers() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        List<NamedCluster> this$clusters = this.getClusters();
        List<NamedCluster> other$clusters = other.getClusters();
        if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
            return false;
        }
        List<NamedContext> this$contexts = this.getContexts();
        List<NamedContext> other$contexts = other.getContexts();
        if (this$contexts == null ? other$contexts != null : !((Object)this$contexts).equals(other$contexts)) {
            return false;
        }
        String this$currentContext = this.getCurrentContext();
        String other$currentContext = other.getCurrentContext();
        if (this$currentContext == null ? other$currentContext != null : !this$currentContext.equals(other$currentContext)) {
            return false;
        }
        List<NamedExtension> this$extensions = this.getExtensions();
        List<NamedExtension> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        Preferences this$preferences = this.getPreferences();
        Preferences other$preferences = other.getPreferences();
        if (this$preferences == null ? other$preferences != null : !((Object)this$preferences).equals(other$preferences)) {
            return false;
        }
        List<NamedAuthInfo> this$users = this.getUsers();
        List<NamedAuthInfo> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        List<NamedCluster> $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        List<NamedContext> $contexts = this.getContexts();
        result = result * 59 + ($contexts == null ? 43 : ((Object)$contexts).hashCode());
        String $currentContext = this.getCurrentContext();
        result = result * 59 + ($currentContext == null ? 43 : $currentContext.hashCode());
        List<NamedExtension> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        Preferences $preferences = this.getPreferences();
        result = result * 59 + ($preferences == null ? 43 : ((Object)$preferences).hashCode());
        List<NamedAuthInfo> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

