/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.v4_0.AuthInfo;
import io.fabric8.kubernetes.api.model.v4_0.Cluster;
import io.fabric8.kubernetes.api.model.v4_0.ConfigBuilder;
import io.fabric8.kubernetes.api.model.v4_0.Context;
import io.fabric8.kubernetes.clnt.v4_0.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_0.RequestConfigHolder;
import io.fabric8.kubernetes.clnt.v4_0.Version;
import io.fabric8.kubernetes.clnt.v4_0.internal.KubeConfigUtils;
import io.fabric8.kubernetes.clnt.v4_0.internal.SSLUtils;
import io.fabric8.kubernetes.clnt.v4_0.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.Map;
import okhttp3.TlsVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true, allowGetters=true, allowSetters=true)
public class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    public static final String KUBERNETES_API_VERSION_SYSTEM_PROPERTY = "kubernetes.api.version";
    public static final String KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY = "kubernetes.trust.certificates";
    public static final String KUBERNETES_DISABLE_HOSTNAME_VERIFICATION_SYSTEM_PROPERTY = "kubernetes.disable.hostname.verification";
    public static final String KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.ca.file";
    public static final String KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.ca.data";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.file";
    public static final String KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.data";
    public static final String KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.file";
    public static final String KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY = "kubernetes.certs.client.key.data";
    public static final String KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY = "kubernetes.certs.client.key.algo";
    public static final String KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY = "kubernetes.certs.client.key.passphrase";
    public static final String KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY = "kubernetes.auth.basic.username";
    public static final String KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY = "kubernetes.auth.basic.password";
    public static final String KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY = "kubernetes.auth.tryKubeConfig";
    public static final String KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY = "kubernetes.auth.tryServiceAccount";
    public static final String KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY = "kubernetes.auth.token";
    public static final String KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY = "kubernetes.watch.reconnectInterval";
    public static final String KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY = "kubernetes.watch.reconnectLimit";
    public static final String KUBERNETES_CONNECTION_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.connection.timeout";
    public static final String KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.request.timeout";
    public static final String KUBERNETES_ROLLING_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.rolling.timeout";
    public static final String KUBERNETES_LOGGING_INTERVAL_SYSTEM_PROPERTY = "kubernetes.logging.interval";
    public static final String KUBERNETES_SCALE_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.scale.timeout";
    public static final String KUBERNETES_WEBSOCKET_TIMEOUT_SYSTEM_PROPERTY = "kubernetes.websocket.timeout";
    public static final String KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY = "kubernetes.websocket.ping.interval";
    public static final String KUBERNETES_MAX_CONCURRENT_REQUESTS = "kubernetes.max.concurrent.requests";
    public static final String KUBERNETES_MAX_CONCURRENT_REQUESTS_PER_HOST = "kubernetes.max.concurrent.requests.per.host";
    public static final String KUBERNETES_IMPERSONATE_USERNAME = "kubernetes.impersonate.username";
    public static final String KUBERNETES_IMPERSONATE_GROUP = "kubernetes.impersonate.group";
    public static final String KUBERNETES_TRUSTSTORE_PASSPHRASE_PROPERTY = "kubernetes.truststore.passphrase";
    public static final String KUBERNETES_TRUSTSTORE_FILE_PROPERTY = "kubernetes.truststore.file";
    public static final String KUBERNETES_KEYSTORE_PASSPHRASE_PROPERTY = "kubernetes.keystore.passphrase";
    public static final String KUBERNETES_KEYSTORE_FILE_PROPERTY = "kubernetes.keystore.file";
    public static final String KUBERNETES_TLS_VERSIONS = "kubernetes.tls.versions";
    public static final String KUBERNETES_TRYNAMESPACE_PATH_SYSTEM_PROPERTY = "kubernetes.tryNamespacePath";
    public static final String KUBERNETES_NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    public static final String KUBERNETES_NAMESPACE_FILE = "kubenamespace";
    public static final String KUBERNETES_NAMESPACE_SYSTEM_PROPERTY = "kubernetes.namespace";
    public static final String KUBERNETES_KUBECONFIG_FILE = "kubeconfig";
    public static final String KUBERNETES_SERVICE_HOST_PROPERTY = "KUBERNETES_SERVICE_HOST";
    public static final String KUBERNETES_SERVICE_PORT_PROPERTY = "KUBERNETES_SERVICE_PORT";
    public static final String KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String KUBERNETES_HTTP_PROXY = "http.proxy";
    public static final String KUBERNETES_HTTPS_PROXY = "https.proxy";
    public static final String KUBERNETES_ALL_PROXY = "all.proxy";
    public static final String KUBERNETES_NO_PROXY = "no.proxy";
    public static final String KUBERNETES_PROXY_USERNAME = "proxy.username";
    public static final String KUBERNETES_PROXY_PASSWORD = "proxy.password";
    public static final String KUBERNETES_USER_AGENT = "fabric8-kubernetes-client/" + Version.clientVersion();
    public static final Long DEFAULT_ROLLING_TIMEOUT = 900000L;
    public static final Long DEFAULT_SCALE_TIMEOUT = 600000L;
    public static final int DEFAULT_LOGGING_INTERVAL = 20000;
    public static final Long DEFAULT_WEBSOCKET_TIMEOUT = 5000L;
    public static final Long DEFAULT_WEBSOCKET_PING_INTERVAL = 1000L;
    public static final Integer DEFAULT_MAX_CONCURRENT_REQUESTS = 64;
    public static final Integer DEFAULT_MAX_CONCURRENT_REQUESTS_PER_HOST = 5;
    public static final String HTTP_PROTOCOL_PREFIX = "http://";
    public static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String ACCESS_TOKEN = "access-token";
    private boolean trustCerts;
    private boolean disableHostnameVerification;
    private String masterUrl = "https://kubernetes.default.svc";
    private String apiVersion = "v1";
    private String namespace;
    private String caCertFile;
    private String caCertData;
    private String clientCertFile;
    private String clientCertData;
    private String clientKeyFile;
    private String clientKeyData;
    private String clientKeyAlgo = "RSA";
    private String clientKeyPassphrase = "changeit";
    private String trustStoreFile;
    private String trustStorePassphrase;
    private String keyStoreFile;
    private String keyStorePassphrase;
    private RequestConfig requestConfig = new RequestConfig();
    private String username;
    private String password;
    private String oauthToken;
    private int watchReconnectInterval = 1000;
    private int watchReconnectLimit = -1;
    private int connectionTimeout = 10000;
    private int requestTimeout = 10000;
    private long rollingTimeout = DEFAULT_ROLLING_TIMEOUT;
    private long scaleTimeout = DEFAULT_SCALE_TIMEOUT;
    private int loggingInterval = 20000;
    private long websocketTimeout = DEFAULT_WEBSOCKET_TIMEOUT;
    private long websocketPingInterval = DEFAULT_WEBSOCKET_PING_INTERVAL;
    private int maxConcurrentRequests = DEFAULT_MAX_CONCURRENT_REQUESTS;
    private int maxConcurrentRequestsPerHost = DEFAULT_MAX_CONCURRENT_REQUESTS_PER_HOST;
    private String impersonateUsername;
    private String impersonateGroup;
    private Map<String, String> impersonateExtras;
    private String httpProxy;
    private String httpsProxy;
    private String proxyUsername;
    private String proxyPassword;
    private String[] noProxy;
    private String userAgent;
    private TlsVersion[] tlsVersions = new TlsVersion[]{TlsVersion.TLS_1_2};
    private Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    @Deprecated
    public Config() {
        Config.autoConfigure(this, null);
    }

    public static Config autoConfigure(String context) {
        Config config = new Config();
        return Config.autoConfigure(config, context);
    }

    private static Config autoConfigure(Config config, String context) {
        if (!Config.tryKubeConfig(config, context)) {
            Config.tryServiceAccount(config);
            Config.tryNamespaceFromPath(config);
        }
        Config.configFromSysPropsOrEnvVars(config);
        if (!config.masterUrl.toLowerCase().startsWith(HTTP_PROTOCOL_PREFIX) && !config.masterUrl.toLowerCase().startsWith(HTTPS_PROTOCOL_PREFIX)) {
            config.masterUrl = (SSLUtils.isHttpsAvailable(config) ? HTTPS_PROTOCOL_PREFIX : HTTP_PROTOCOL_PREFIX) + config.masterUrl;
        }
        if (!config.masterUrl.endsWith("/")) {
            config.masterUrl = config.masterUrl + "/";
        }
        return config;
    }

    public Config(String masterUrl, String apiVersion, String namespace, boolean trustCerts, boolean disableHostnameVerification, String caCertFile, String caCertData, String clientCertFile, String clientCertData, String clientKeyFile, String clientKeyData, String clientKeyAlgo, String clientKeyPassphrase, String username, String password, String oauthToken, int watchReconnectInterval, int watchReconnectLimit, int connectionTimeout, int requestTimeout, long rollingTimeout, long scaleTimeout, int loggingInterval, int maxConcurrentRequestsPerHost, String httpProxy, String httpsProxy, String[] noProxy, Map<Integer, String> errorMessages, String userAgent, TlsVersion[] tlsVersions, long websocketTimeout, long websocketPingInterval, String proxyUsername, String proxyPassword, String trustStoreFile, String trustStorePassphrase, String keyStoreFile, String keyStorePassphrase, String impersonateUsername, String impersonateGroup, Map<String, String> impersonateExtras) {
        this.masterUrl = masterUrl;
        this.apiVersion = apiVersion;
        this.namespace = namespace;
        this.trustCerts = trustCerts;
        this.disableHostnameVerification = disableHostnameVerification;
        this.caCertFile = caCertFile;
        this.caCertData = caCertData;
        this.clientCertFile = clientCertFile;
        this.clientCertData = clientCertData;
        this.clientKeyFile = clientKeyFile;
        this.clientKeyData = clientKeyData;
        this.clientKeyAlgo = clientKeyAlgo;
        this.clientKeyPassphrase = clientKeyPassphrase;
        this.requestConfig = new RequestConfig(username, password, oauthToken, watchReconnectLimit, watchReconnectInterval, connectionTimeout, rollingTimeout, requestTimeout, scaleTimeout, loggingInterval, websocketTimeout, websocketPingInterval, this.maxConcurrentRequests, maxConcurrentRequestsPerHost);
        this.requestConfig.setImpersonateUsername(impersonateUsername);
        this.requestConfig.setImpersonateGroup(impersonateGroup);
        this.requestConfig.setImpersonateExtras(impersonateExtras);
        this.httpProxy = httpProxy;
        this.httpsProxy = httpsProxy;
        this.noProxy = noProxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.errorMessages = errorMessages;
        this.userAgent = userAgent;
        this.tlsVersions = tlsVersions;
        if (!this.masterUrl.toLowerCase().startsWith(HTTP_PROTOCOL_PREFIX) && !this.masterUrl.startsWith(HTTPS_PROTOCOL_PREFIX)) {
            this.masterUrl = (SSLUtils.isHttpsAvailable(this) ? HTTPS_PROTOCOL_PREFIX : HTTP_PROTOCOL_PREFIX) + this.masterUrl;
        }
        if (!this.masterUrl.endsWith("/")) {
            this.masterUrl = this.masterUrl + "/";
        }
        this.trustStoreFile = trustStoreFile;
        this.trustStorePassphrase = trustStorePassphrase;
        this.keyStoreFile = keyStoreFile;
        this.keyStorePassphrase = keyStorePassphrase;
    }

    public static void configFromSysPropsOrEnvVars(Config config) {
        String tlsVersionsVar;
        String configuredMaxConcurrentReqeustsPerHost;
        String configuredWebsocketPingInterval;
        String configuredLoggingInterval;
        String configuredScaleTimeout;
        String configuredRollingTimeout;
        String configuredWatchReconnectLimit;
        config.setTrustCerts(Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUST_CERT_SYSTEM_PROPERTY, config.isTrustCerts()));
        config.setDisableHostnameVerification(Utils.getSystemPropertyOrEnvVar(KUBERNETES_DISABLE_HOSTNAME_VERIFICATION_SYSTEM_PROPERTY, config.isDisableHostnameVerification()));
        config.setMasterUrl(Utils.getSystemPropertyOrEnvVar(KUBERNETES_MASTER_SYSTEM_PROPERTY, config.getMasterUrl()));
        config.setApiVersion(Utils.getSystemPropertyOrEnvVar(KUBERNETES_API_VERSION_SYSTEM_PROPERTY, config.getApiVersion()));
        config.setNamespace(Utils.getSystemPropertyOrEnvVar(KUBERNETES_NAMESPACE_SYSTEM_PROPERTY, config.getNamespace()));
        config.setCaCertFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CA_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getCaCertFile()));
        config.setCaCertData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CA_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getCaCertData()));
        config.setClientCertFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_CERTIFICATE_FILE_SYSTEM_PROPERTY, config.getClientCertFile()));
        config.setClientCertData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_CERTIFICATE_DATA_SYSTEM_PROPERTY, config.getClientCertData()));
        config.setClientKeyFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_FILE_SYSTEM_PROPERTY, config.getClientKeyFile()));
        config.setClientKeyData(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_DATA_SYSTEM_PROPERTY, config.getClientKeyData()));
        config.setClientKeyAlgo(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_ALGO_SYSTEM_PROPERTY, config.getClientKeyAlgo()));
        config.setClientKeyPassphrase(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CLIENT_KEY_PASSPHRASE_SYSTEM_PROPERTY, new String(config.getClientKeyPassphrase())));
        config.setUserAgent(Utils.getSystemPropertyOrEnvVar(KUBERNETES_USER_AGENT, config.getUserAgent()));
        config.setTrustStorePassphrase(Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUSTSTORE_PASSPHRASE_PROPERTY, config.getTrustStorePassphrase()));
        config.setTrustStoreFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRUSTSTORE_FILE_PROPERTY, config.getTrustStoreFile()));
        config.setKeyStorePassphrase(Utils.getSystemPropertyOrEnvVar(KUBERNETES_KEYSTORE_PASSPHRASE_PROPERTY, config.getKeyStorePassphrase()));
        config.setKeyStoreFile(Utils.getSystemPropertyOrEnvVar(KUBERNETES_KEYSTORE_FILE_PROPERTY, config.getKeyStoreFile()));
        config.setOauthToken(Utils.getSystemPropertyOrEnvVar(KUBERNETES_OAUTH_TOKEN_SYSTEM_PROPERTY, config.getOauthToken()));
        config.setUsername(Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_BASIC_USERNAME_SYSTEM_PROPERTY, config.getUsername()));
        config.setPassword(Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_BASIC_PASSWORD_SYSTEM_PROPERTY, config.getPassword()));
        config.setImpersonateUsername(Utils.getSystemPropertyOrEnvVar(KUBERNETES_IMPERSONATE_USERNAME, config.getImpersonateUsername()));
        config.setImpersonateGroup(Utils.getSystemPropertyOrEnvVar(KUBERNETES_IMPERSONATE_GROUP, config.getImpersonateGroup()));
        String configuredWatchReconnectInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WATCH_RECONNECT_INTERVAL_SYSTEM_PROPERTY);
        if (configuredWatchReconnectInterval != null) {
            config.setWatchReconnectInterval(Integer.parseInt(configuredWatchReconnectInterval));
        }
        if ((configuredWatchReconnectLimit = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WATCH_RECONNECT_LIMIT_SYSTEM_PROPERTY)) != null) {
            config.setWatchReconnectLimit(Integer.parseInt(configuredWatchReconnectLimit));
        }
        if ((configuredRollingTimeout = Utils.getSystemPropertyOrEnvVar(KUBERNETES_ROLLING_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(DEFAULT_ROLLING_TIMEOUT))) != null) {
            config.setRollingTimeout(Long.parseLong(configuredRollingTimeout));
        }
        if ((configuredScaleTimeout = Utils.getSystemPropertyOrEnvVar(KUBERNETES_SCALE_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(DEFAULT_SCALE_TIMEOUT))) != null) {
            config.setScaleTimeout(Long.parseLong(configuredScaleTimeout));
        }
        if ((configuredLoggingInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_LOGGING_INTERVAL_SYSTEM_PROPERTY, String.valueOf(20000))) != null) {
            config.setLoggingInterval(Integer.parseInt(configuredLoggingInterval));
        }
        config.setConnectionTimeout(Utils.getSystemPropertyOrEnvVar(KUBERNETES_CONNECTION_TIMEOUT_SYSTEM_PROPERTY, config.getConnectionTimeout()));
        config.setRequestTimeout(Utils.getSystemPropertyOrEnvVar(KUBERNETES_REQUEST_TIMEOUT_SYSTEM_PROPERTY, config.getRequestTimeout()));
        String configuredWebsocketTimeout = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WEBSOCKET_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(config.getWebsocketTimeout()));
        if (configuredWebsocketTimeout != null) {
            config.setWebsocketTimeout(Long.parseLong(configuredWebsocketTimeout));
        }
        if ((configuredWebsocketPingInterval = Utils.getSystemPropertyOrEnvVar(KUBERNETES_WEBSOCKET_PING_INTERVAL_SYSTEM_PROPERTY, String.valueOf(config.getWebsocketPingInterval()))) != null) {
            config.setWebsocketPingInterval(Long.parseLong(configuredWebsocketPingInterval));
        }
        if ((configuredMaxConcurrentReqeustsPerHost = Utils.getSystemPropertyOrEnvVar(KUBERNETES_MAX_CONCURRENT_REQUESTS_PER_HOST, String.valueOf(config.getMaxConcurrentRequestsPerHost()))) != null) {
            config.setMaxConcurrentRequestsPerHost(Integer.parseInt(configuredMaxConcurrentReqeustsPerHost));
        }
        config.setHttpProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_ALL_PROXY, config.getHttpProxy()));
        config.setHttpsProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_ALL_PROXY, config.getHttpsProxy()));
        config.setHttpsProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_HTTPS_PROXY, config.getHttpsProxy()));
        config.setHttpProxy(Utils.getSystemPropertyOrEnvVar(KUBERNETES_HTTP_PROXY, config.getHttpProxy()));
        config.setProxyUsername(Utils.getSystemPropertyOrEnvVar(KUBERNETES_PROXY_USERNAME, config.getProxyUsername()));
        config.setProxyPassword(Utils.getSystemPropertyOrEnvVar(KUBERNETES_PROXY_PASSWORD, config.getProxyPassword()));
        String noProxyVar = Utils.getSystemPropertyOrEnvVar(KUBERNETES_NO_PROXY);
        if (noProxyVar != null) {
            config.setNoProxy(noProxyVar.split(","));
        }
        if ((tlsVersionsVar = Utils.getSystemPropertyOrEnvVar(KUBERNETES_TLS_VERSIONS)) != null && !tlsVersionsVar.isEmpty()) {
            String[] tlsVersionsSplit = tlsVersionsVar.split(",");
            TlsVersion[] tlsVersions = new TlsVersion[tlsVersionsSplit.length];
            for (int i = 0; i < tlsVersionsSplit.length; ++i) {
                tlsVersions[i] = TlsVersion.forJavaName((String)tlsVersionsSplit[i]);
            }
            config.setTlsVersions(tlsVersions);
        }
    }

    private static boolean tryServiceAccount(Config config) {
        LOGGER.debug("Trying to configure client from service account...");
        String masterHost = Utils.getSystemPropertyOrEnvVar(KUBERNETES_SERVICE_HOST_PROPERTY, (String)null);
        String masterPort = Utils.getSystemPropertyOrEnvVar(KUBERNETES_SERVICE_PORT_PROPERTY, (String)null);
        if (masterHost != null && masterPort != null) {
            String hostPort = Config.joinHostPort(masterHost, masterPort);
            LOGGER.debug("Found service account host and port: " + hostPort);
            config.setMasterUrl(HTTPS_PROTOCOL_PREFIX + hostPort);
        }
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYSERVICEACCOUNT_SYSTEM_PROPERTY, true).booleanValue()) {
            boolean serviceAccountCaCertExists = Files.isRegularFile(new File(KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH).toPath(), new LinkOption[0]);
            if (serviceAccountCaCertExists) {
                LOGGER.debug("Found service account ca cert at: [/var/run/secrets/kubernetes.io/serviceaccount/ca.crt].");
                config.setCaCertFile(KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH);
            } else {
                LOGGER.debug("Did not find service account ca cert at: [/var/run/secrets/kubernetes.io/serviceaccount/ca.crt].");
            }
            try {
                String serviceTokenCandidate = new String(Files.readAllBytes(new File(KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH).toPath()));
                if (serviceTokenCandidate != null) {
                    LOGGER.debug("Found service account token at: [/var/run/secrets/kubernetes.io/serviceaccount/token].");
                    config.setOauthToken(serviceTokenCandidate);
                    String txt = "Configured service account doesn't have access. Service account may have been revoked.";
                    config.getErrorMessages().put(401, "Unauthorized! " + txt);
                    config.getErrorMessages().put(403, "Forbidden!" + txt);
                    return true;
                }
                LOGGER.debug("Did not find service account token at: [/var/run/secrets/kubernetes.io/serviceaccount/token].");
            }
            catch (IOException e) {
                LOGGER.warn("Error reading service account token from: [/var/run/secrets/kubernetes.io/serviceaccount/token]. Ignoring.");
            }
        }
        return false;
    }

    private static String joinHostPort(String host, String port) {
        if (host.indexOf(58) >= 0) {
            return "[" + host + "]:" + port;
        }
        return host + ":" + port;
    }

    private static String absolutify(File relativeTo, String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file.getAbsolutePath();
        }
        return new File(relativeTo.getParentFile(), filename).getAbsolutePath();
    }

    public static Config fromKubeconfig(String kubeconfigContents) {
        return Config.fromKubeconfig(null, kubeconfigContents, null);
    }

    public static Config fromKubeconfig(String context, String kubeconfigContents, String kubeconfigPath) {
        Config config = new Config();
        Config.loadFromKubeconfig(config, null, kubeconfigContents, kubeconfigPath);
        return config;
    }

    private static boolean tryKubeConfig(Config config, String context) {
        LOGGER.debug("Trying to configure client from Kubernetes config...");
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_AUTH_TRYKUBECONFIG_SYSTEM_PROPERTY, true).booleanValue()) {
            File kubeConfigFile = new File(Utils.getSystemPropertyOrEnvVar(KUBERNETES_KUBECONFIG_FILE, new File(Config.getHomeDir(), ".kube" + File.separator + "config").toString()));
            boolean kubeConfigFileExists = Files.isRegularFile(kubeConfigFile.toPath(), new LinkOption[0]);
            if (kubeConfigFileExists) {
                String kubeconfigContents;
                LOGGER.debug("Found for Kubernetes config at: [" + kubeConfigFile.getPath() + "].");
                try {
                    kubeconfigContents = new String(Files.readAllBytes(kubeConfigFile.toPath()), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    LOGGER.error("Could not load Kubernetes config file from {}", (Object)kubeConfigFile.getPath(), (Object)e);
                    return false;
                }
                Config.loadFromKubeconfig(config, context, kubeconfigContents, kubeConfigFile.getPath());
                return true;
            }
            LOGGER.debug("Did not find Kubernetes config at: [" + kubeConfigFile.getPath() + "]. Ignoring.");
        }
        return false;
    }

    private static boolean loadFromKubeconfig(Config config, String context, String kubeconfigContents, String kubeconfigPath) {
        try {
            Context currentContext;
            Cluster currentCluster;
            io.fabric8.kubernetes.api.model.v4_0.Config kubeConfig = KubeConfigUtils.parseConfigFromString(kubeconfigContents);
            if (context != null) {
                kubeConfig.setCurrentContext(context);
            }
            if ((currentCluster = KubeConfigUtils.getCluster(kubeConfig, currentContext = KubeConfigUtils.getCurrentContext(kubeConfig))) != null) {
                config.setMasterUrl(currentCluster.getServer());
                config.setNamespace(currentContext.getNamespace());
                config.setTrustCerts(currentCluster.getInsecureSkipTlsVerify() != null && currentCluster.getInsecureSkipTlsVerify() != false);
                config.setDisableHostnameVerification(currentCluster.getInsecureSkipTlsVerify() != null && currentCluster.getInsecureSkipTlsVerify() != false);
                config.setCaCertData(currentCluster.getCertificateAuthorityData());
                AuthInfo currentAuthInfo = KubeConfigUtils.getUserAuthInfo(kubeConfig, currentContext);
                if (currentAuthInfo != null) {
                    String caCertFile = currentCluster.getCertificateAuthority();
                    String clientCertFile = currentAuthInfo.getClientCertificate();
                    String clientKeyFile = currentAuthInfo.getClientKey();
                    if (kubeconfigPath != null && !kubeconfigPath.isEmpty()) {
                        caCertFile = Config.absolutify(new File(kubeconfigPath), currentCluster.getCertificateAuthority());
                        clientCertFile = Config.absolutify(new File(kubeconfigPath), currentAuthInfo.getClientCertificate());
                        clientKeyFile = Config.absolutify(new File(kubeconfigPath), currentAuthInfo.getClientKey());
                    }
                    config.setCaCertFile(caCertFile);
                    config.setClientCertFile(clientCertFile);
                    config.setClientCertData(currentAuthInfo.getClientCertificateData());
                    config.setClientKeyFile(clientKeyFile);
                    config.setClientKeyData(currentAuthInfo.getClientKeyData());
                    config.setOauthToken(currentAuthInfo.getToken());
                    config.setUsername(currentAuthInfo.getUsername());
                    config.setPassword(currentAuthInfo.getPassword());
                    if (Utils.isNullOrEmpty(config.getOauthToken()) && currentAuthInfo.getAuthProvider() != null && !Utils.isNullOrEmpty(currentAuthInfo.getAuthProvider().getConfig().get(ACCESS_TOKEN))) {
                        config.setOauthToken(currentAuthInfo.getAuthProvider().getConfig().get(ACCESS_TOKEN));
                    }
                    config.getErrorMessages().put(401, "Unauthorized! Token may have expired! Please log-in again.");
                    config.getErrorMessages().put(403, "Forbidden! User " + currentContext.getUser() + " doesn't have permission.");
                }
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse the kubeconfig.", (Throwable)e);
        }
        return false;
    }

    private static boolean tryNamespaceFromPath(Config config) {
        LOGGER.debug("Trying to configure client namespace from Kubernetes service account namespace path...");
        if (Utils.getSystemPropertyOrEnvVar(KUBERNETES_TRYNAMESPACE_PATH_SYSTEM_PROPERTY, true).booleanValue()) {
            String serviceAccountNamespace = Utils.getSystemPropertyOrEnvVar(KUBERNETES_NAMESPACE_FILE, KUBERNETES_NAMESPACE_PATH);
            boolean serviceAccountNamespaceExists = Files.isRegularFile(new File(serviceAccountNamespace).toPath(), new LinkOption[0]);
            if (serviceAccountNamespaceExists) {
                LOGGER.debug("Found service account namespace at: [" + serviceAccountNamespace + "].");
                try {
                    String namespace = new String(Files.readAllBytes(new File(serviceAccountNamespace).toPath()));
                    config.setNamespace(namespace.replace(System.lineSeparator(), ""));
                    return true;
                }
                catch (IOException e) {
                    LOGGER.error("Error reading service account namespace from: [" + serviceAccountNamespace + "].", (Throwable)e);
                }
            } else {
                LOGGER.debug("Did not find service account namespace at: [" + serviceAccountNamespace + "]. Ignoring.");
            }
        }
        return false;
    }

    private static String getHomeDir() {
        File f;
        String home;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("win")) {
            String homeDir;
            File f2;
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homeDrive != null && !homeDrive.isEmpty() && homePath != null && !homePath.isEmpty() && (f2 = new File(homeDir = homeDrive + homePath)).exists() && f2.isDirectory()) {
                return homeDir;
            }
            String userProfile = System.getenv("USERPROFILE");
            if (userProfile != null && !userProfile.isEmpty() && (f2 = new File(userProfile)).exists() && f2.isDirectory()) {
                return userProfile;
            }
        }
        if ((home = System.getenv("HOME")) != null && !home.isEmpty() && (f = new File(home)).exists() && f.isDirectory()) {
            return home;
        }
        return System.getProperty("user.home", ".");
    }

    @JsonProperty(value="oauthToken")
    public String getOauthToken() {
        return this.getRequestConfig().getOauthToken();
    }

    public void setOauthToken(String oauthToken) {
        this.requestConfig.setOauthToken(oauthToken);
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.getRequestConfig().getPassword();
    }

    public void setPassword(String password) {
        this.requestConfig.setPassword(password);
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.getRequestConfig().getUsername();
    }

    public void setUsername(String username) {
        this.requestConfig.setUsername(username);
    }

    @JsonProperty(value="impersonateUsername")
    public String getImpersonateUsername() {
        return this.getRequestConfig().getImpersonateUsername();
    }

    public void setImpersonateUsername(String impersonateUsername) {
        this.requestConfig.setImpersonateUsername(impersonateUsername);
    }

    @JsonProperty(value="impersonateGroup")
    public String getImpersonateGroup() {
        return this.getRequestConfig().getImpersonateGroup();
    }

    public void setImpersonateGroup(String impersonateGroup) {
        this.requestConfig.setImpersonateGroup(impersonateGroup);
    }

    @JsonProperty(value="impersonateExtras")
    public Map<String, String> getImpersonateExtras() {
        return this.getRequestConfig().getImpersonateExtras();
    }

    public void setImpersonateExtras(Map<String, String> impersonateExtras) {
        this.requestConfig.setImpersonateExtras(impersonateExtras);
    }

    @JsonProperty(value="clientKeyPassphrase")
    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    public void setClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
    }

    @JsonProperty(value="clientKeyAlgo")
    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    public void setClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
    }

    @JsonProperty(value="clientKeyData")
    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public void setClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
    }

    @JsonProperty(value="clientKeyFile")
    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    public void setClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
    }

    @JsonProperty(value="clientCertData")
    public String getClientCertData() {
        return this.clientCertData;
    }

    public void setClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
    }

    @JsonProperty(value="clientCertFile")
    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public void setClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
    }

    @JsonProperty(value="caCertData")
    public String getCaCertData() {
        return this.caCertData;
    }

    public void setCaCertData(String caCertData) {
        this.caCertData = caCertData;
    }

    @JsonProperty(value="caCertFile")
    public String getCaCertFile() {
        return this.caCertFile;
    }

    public void setCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="masterUrl")
    public String getMasterUrl() {
        return this.masterUrl;
    }

    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    @JsonProperty(value="trustCerts")
    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    public void setTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
    }

    @JsonProperty(value="disableHostnameVerification")
    public boolean isDisableHostnameVerification() {
        return this.disableHostnameVerification;
    }

    public void setDisableHostnameVerification(boolean disableHostnameVerification) {
        this.disableHostnameVerification = disableHostnameVerification;
    }

    @JsonProperty(value="watchReconnectInterval")
    public int getWatchReconnectInterval() {
        return this.requestConfig.getWatchReconnectInterval();
    }

    public void setWatchReconnectInterval(int watchReconnectInterval) {
        this.requestConfig.setWatchReconnectInterval(watchReconnectInterval);
    }

    @JsonProperty(value="watchReconnectLimit")
    public int getWatchReconnectLimit() {
        return this.getRequestConfig().getWatchReconnectLimit();
    }

    public void setWatchReconnectLimit(int watchReconnectLimit) {
        this.requestConfig.setWatchReconnectLimit(watchReconnectLimit);
    }

    @JsonProperty(value="errorMessages")
    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    @JsonProperty(value="connectionTimeout")
    public int getConnectionTimeout() {
        return this.getRequestConfig().getConnectionTimeout();
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.requestConfig.setConnectionTimeout(connectionTimeout);
    }

    @JsonProperty(value="requestTimeout")
    public int getRequestTimeout() {
        return this.getRequestConfig().getRequestTimeout();
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestConfig.setRequestTimeout(requestTimeout);
    }

    @JsonProperty(value="rollingTimeout")
    public long getRollingTimeout() {
        return this.getRequestConfig().getRollingTimeout();
    }

    public void setRollingTimeout(long rollingTimeout) {
        this.requestConfig.setRollingTimeout(rollingTimeout);
    }

    @JsonProperty(value="scaleTimeout")
    public long getScaleTimeout() {
        return this.getRequestConfig().getScaleTimeout();
    }

    public void setScaleTimeout(long scaleTimeout) {
        this.requestConfig.setScaleTimeout(scaleTimeout);
    }

    @JsonProperty(value="loggingInterval")
    public int getLoggingInterval() {
        return this.getRequestConfig().getLoggingInterval();
    }

    public void setLoggingInterval(int loggingInterval) {
        this.requestConfig.setLoggingInterval(loggingInterval);
    }

    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    @JsonProperty(value="httpProxy")
    public String getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
    }

    @JsonProperty(value="httpsProxy")
    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public void setNoProxy(String[] noProxy) {
        this.noProxy = noProxy;
    }

    @JsonProperty(value="noProxy")
    public String[] getNoProxy() {
        return this.noProxy;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="userAgent")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @JsonProperty(value="tlsVersions")
    public TlsVersion[] getTlsVersions() {
        return this.tlsVersions;
    }

    public void setTlsVersions(TlsVersion[] tlsVersions) {
        this.tlsVersions = tlsVersions;
    }

    @JsonProperty(value="websocketTimeout")
    public long getWebsocketTimeout() {
        return this.getRequestConfig().getWebsocketTimeout();
    }

    public void setWebsocketTimeout(long websocketTimeout) {
        this.requestConfig.setWebsocketTimeout(websocketTimeout);
    }

    @JsonProperty(value="websocketPingInterval")
    public long getWebsocketPingInterval() {
        return this.getRequestConfig().getWebsocketPingInterval();
    }

    public void setWebsocketPingInterval(long websocketPingInterval) {
        this.requestConfig.setWebsocketPingInterval(websocketPingInterval);
    }

    public int getMaxConcurrentRequests() {
        return this.getRequestConfig().getMaxConcurrentRequests();
    }

    public void setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.requestConfig.setMaxConcurrentRequests(maxConcurrentRequests);
    }

    public int getMaxConcurrentRequestsPerHost() {
        return this.getRequestConfig().getMaxConcurrentRequestsPerHost();
    }

    public void setMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.requestConfig.setMaxConcurrentRequestsPerHost(maxConcurrentRequestsPerHost);
    }

    @JsonProperty(value="proxyUsername")
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @JsonProperty(value="proxyPassword")
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public RequestConfig getRequestConfig() {
        RequestConfig rc = RequestConfigHolder.get();
        return rc != null ? rc : this.requestConfig;
    }

    public void setTrustStorePassphrase(String trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
    }

    @JsonProperty(value="trustStorePassphrase")
    public String getTrustStorePassphrase() {
        return this.trustStorePassphrase;
    }

    public void setKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
    }

    @JsonProperty(value="keyStorePassphrase")
    public String getKeyStorePassphrase() {
        return this.keyStorePassphrase;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    @JsonProperty(value="trustStoreFile")
    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    @JsonProperty(value="keyStoreFile")
    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }
}

