/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_0;

import io.fabric8.kubernetes.clnt.v4_0.Client;
import io.fabric8.kubernetes.clnt.v4_0.ExtensionAdapter;
import io.fabric8.openshift.clnt.v4_0.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v4_0.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v4_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_0.OpenShiftNotAvailableException;
import io.fabric8.openshift.clnt.v4_0.OpenshiftAdapterSupport;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class NamespacedOpenShiftExtensionAdapter
extends OpenshiftAdapterSupport
implements ExtensionAdapter<NamespacedOpenShiftClient> {
    @Override
    public Class<NamespacedOpenShiftClient> getExtensionType() {
        return NamespacedOpenShiftClient.class;
    }

    @Override
    public NamespacedOpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include /oapi or the new /apis/*.openshift.io APIs.");
        }
        return new DefaultOpenShiftClient(client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }
}

