/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceMetricStatus;
import io.fabric8.kubernetes.api.model.ResourceMetricStatusFluent;

public class ResourceMetricStatusFluentImpl<A extends ResourceMetricStatusFluent<A>>
extends BaseFluent<A>
implements ResourceMetricStatusFluent<A> {
    private Integer currentAverageUtilization;
    private QuantityBuilder currentAverageValue;
    private String name;

    public ResourceMetricStatusFluentImpl() {
    }

    public ResourceMetricStatusFluentImpl(ResourceMetricStatus instance) {
        this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withName(instance.getName());
    }

    @Override
    public Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    @Override
    public A withCurrentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization = currentAverageUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageUtilization() {
        return this.currentAverageUtilization != null;
    }

    @Override
    @Deprecated
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue != null ? this.currentAverageValue.build() : null;
    }

    @Override
    public Quantity buildCurrentAverageValue() {
        return this.currentAverageValue != null ? this.currentAverageValue.build() : null;
    }

    @Override
    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this._visitables.remove(this.currentAverageValue);
        if (currentAverageValue != null) {
            this.currentAverageValue = new QuantityBuilder(currentAverageValue);
            this._visitables.add(this.currentAverageValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    @Override
    public A withNewCurrentAverageValue(String amount, String format) {
        return this.withCurrentAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewCurrentAverageValue(String amount) {
        return this.withCurrentAverageValue(new Quantity(amount));
    }

    @Override
    public ResourceMetricStatusFluent.CurrentAverageValueNested<A> withNewCurrentAverageValue() {
        return new CurrentAverageValueNestedImpl();
    }

    @Override
    public ResourceMetricStatusFluent.CurrentAverageValueNested<A> withNewCurrentAverageValueLike(Quantity item) {
        return new CurrentAverageValueNestedImpl(item);
    }

    @Override
    public ResourceMetricStatusFluent.CurrentAverageValueNested<A> editCurrentAverageValue() {
        return this.withNewCurrentAverageValueLike(this.getCurrentAverageValue());
    }

    @Override
    public ResourceMetricStatusFluent.CurrentAverageValueNested<A> editOrNewCurrentAverageValue() {
        return this.withNewCurrentAverageValueLike(this.getCurrentAverageValue() != null ? this.getCurrentAverageValue() : new QuantityBuilder().build());
    }

    @Override
    public ResourceMetricStatusFluent.CurrentAverageValueNested<A> editOrNewCurrentAverageValueLike(Quantity item) {
        return this.withNewCurrentAverageValueLike(this.getCurrentAverageValue() != null ? this.getCurrentAverageValue() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricStatusFluentImpl that = (ResourceMetricStatusFluentImpl)o;
        if (this.currentAverageUtilization != null ? !this.currentAverageUtilization.equals(that.currentAverageUtilization) : that.currentAverageUtilization != null) {
            return false;
        }
        if (this.currentAverageValue != null ? !this.currentAverageValue.equals(that.currentAverageValue) : that.currentAverageValue != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public class CurrentAverageValueNestedImpl<N>
    extends QuantityFluentImpl<ResourceMetricStatusFluent.CurrentAverageValueNested<N>>
    implements ResourceMetricStatusFluent.CurrentAverageValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        CurrentAverageValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        CurrentAverageValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceMetricStatusFluentImpl.this.withCurrentAverageValue(this.builder.build());
        }

        @Override
        public N endCurrentAverageValue() {
            return this.and();
        }
    }
}

