/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetCondition;
import io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetConditionFluentImpl;
import javax.validation.Validator;

public class StatefulSetConditionBuilder
extends StatefulSetConditionFluentImpl<StatefulSetConditionBuilder>
implements VisitableBuilder<StatefulSetCondition, StatefulSetConditionBuilder> {
    StatefulSetConditionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StatefulSetConditionBuilder() {
        this(true);
    }

    public StatefulSetConditionBuilder(Boolean validationEnabled) {
        this(new StatefulSetCondition(), validationEnabled);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetCondition(), validationEnabled);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, StatefulSetCondition instance) {
        this(fluent, instance, true);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, StatefulSetCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetConditionBuilder(StatefulSetCondition instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetConditionBuilder(StatefulSetCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetConditionBuilder(Validator validator) {
        this(new StatefulSetCondition(), (Boolean)true);
    }

    public StatefulSetConditionBuilder(StatefulSetConditionFluent<?> fluent, StatefulSetCondition instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StatefulSetConditionBuilder(StatefulSetCondition instance, Validator validator) {
        this.fluent = this;
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public StatefulSetCondition build() {
        StatefulSetCondition buildable = new StatefulSetCondition(this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetConditionBuilder that = (StatefulSetConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

