/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.apps.DoneableReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigOperationsImpl
extends OpenShiftOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>>
implements DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentConfigOperationsImpl.class);
    private static final String DEPLOYMENT_CONFIG_REF = "openshift.io/deployment-config.name";

    public DeploymentConfigOperationsImpl(OkHttpClient client, Config config) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public DeploymentConfigOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps.openshift.io").withPlural("deploymentconfigs"));
        this.type = DeploymentConfig.class;
        this.listType = DeploymentConfigList.class;
        this.doneableType = DoneableDeploymentConfig.class;
    }

    public DeploymentConfigOperationsImpl newInstance(OperationContext context) {
        return new DeploymentConfigOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public DoneableDeploymentConfig edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeploymentConfig)this.cascading(false).edit();
        }
        return (DoneableDeploymentConfig)super.edit();
    }

    @Override
    public DeploymentConfig replace(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public DeploymentConfig patch(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    @Override
    public DeploymentConfig deployLatest() {
        return this.deployLatest(false);
    }

    @Override
    public DeploymentConfig deployLatest(boolean wait) {
        Long currentVersion = ((DeploymentConfig)this.getMandatory()).getStatus().getLatestVersion();
        if (currentVersion == null) {
            currentVersion = 1L;
        }
        currentVersion = currentVersion + 1L;
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.StatusNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editStatus().withLatestVersion(currentVersion)).endStatus()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(deployment.getSpec().getReplicas());
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public DeploymentConfig scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public DeploymentConfig scale(int count, boolean wait) {
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(count);
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentConfigIsScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = () -> {
            try {
                int currentReplicas;
                DeploymentConfig deploymentConfig = (DeploymentConfig)this.get();
                if (deploymentConfig == null) {
                    if (count == 0) {
                        queue.put(true);
                        return;
                    }
                    queue.put(new IllegalStateException("Can't wait for DeploymentConfig: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available."));
                    return;
                }
                replicasRef.set(deploymentConfig.getStatus().getReplicas());
                int n = currentReplicas = deploymentConfig.getStatus().getReplicas() != null ? deploymentConfig.getStatus().getReplicas() : 0;
                if (deploymentConfig.getStatus().getObservedGeneration() >= deploymentConfig.getMetadata().getGeneration() && Objects.equals(deploymentConfig.getSpec().getReplicas(), currentReplicas)) {
                    queue.put(true);
                } else {
                    LOG.debug("Only {}/{} pods scheduled for DeploymentConfig: {} in namespace: {} seconds so waiting...", new Object[]{deploymentConfig.getStatus().getReplicas(), deploymentConfig.getSpec().getReplicas(), deploymentConfig.getMetadata().getName(), namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Deployment to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> rcList = this.doGetLog();
        for (RollableScalableResource<ReplicaSet, DoneableReplicaSet> rcOperation : rcList) {
            stringBuilder.append((String)rcOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> doGetLog() {
        ArrayList<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> rcs = new ArrayList<RollableScalableResource<ReplicaSet, DoneableReplicaSet>>();
        DeploymentConfig deploymentConfig = (DeploymentConfig)this.fromServer().get();
        String rcUid = deploymentConfig.getMetadata().getUid();
        ReplicaSetOperationsImpl rsOperations = new ReplicaSetOperationsImpl((RollingOperationContext)this.context);
        ReplicaSetList rcList = (ReplicaSetList)rsOperations.withLabels(deploymentConfig.getMetadata().getLabels()).list();
        for (ReplicaSet rs : rcList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid((HasMetadata)rs);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            rcs.add((RollableScalableResource<ReplicaSet, DoneableReplicaSet>)rsOperations.withName(rs.getMetadata().getName()));
        }
        return rcs;
    }

    @Override
    public Reader getLogReader() {
        List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> podResources = this.doGetLog();
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<RollableScalableResource<ReplicaSet, DoneableReplicaSet>> podResources = this.doGetLog();
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }
}

