/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_10;

import io.fabric8.kubernetes.api.builder.v4_10.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_10.Nested;
import io.fabric8.kubernetes.api.model.v4_10.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.v4_10.CSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v4_10.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v4_10.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_10.LocalObjectReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;

public class CSIVolumeSourceFluentImpl<A extends CSIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CSIVolumeSourceFluent<A> {
    private String driver;
    private String fsType;
    private LocalObjectReferenceBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;

    public CSIVolumeSourceFluentImpl() {
    }

    public CSIVolumeSourceFluentImpl(CSIVolumeSource instance) {
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeAttributes(instance.getVolumeAttributes());
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.driver != null;
    }

    @Override
    public A withNewDriver(String arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public A withNewDriver(StringBuilder arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public A withNewDriver(StringBuffer arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A withNewFsType(String arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuilder arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuffer arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    @Deprecated
    public LocalObjectReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public A withNodePublishSecretRef(LocalObjectReference nodePublishSecretRef) {
        this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new LocalObjectReferenceBuilder(nodePublishSecretRef);
            this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    @Override
    public A withNewNodePublishSecretRef(String name) {
        return this.withNodePublishSecretRef(new LocalObjectReference(name));
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNestedImpl();
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(LocalObjectReference item) {
        return new NodePublishSecretRefNestedImpl(item);
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef());
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(LocalObjectReference item) {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : item);
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    @Override
    public A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)this;
    }

    @Override
    public Boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSIVolumeSourceFluentImpl that = (CSIVolumeSourceFluentImpl)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.nodePublishSecretRef != null ? !this.nodePublishSecretRef.equals(that.nodePublishSecretRef) : that.nodePublishSecretRef != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        return !(this.volumeAttributes != null ? !this.volumeAttributes.equals(that.volumeAttributes) : that.volumeAttributes != null);
    }

    public class NodePublishSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CSIVolumeSourceFluent.NodePublishSecretRefNested<N>>
    implements CSIVolumeSourceFluent.NodePublishSecretRefNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        NodePublishSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        NodePublishSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIVolumeSourceFluentImpl.this.withNodePublishSecretRef(this.builder.build());
        }

        @Override
        public N endNodePublishSecretRef() {
            return this.and();
        }
    }
}

