/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_10.apps;

import io.fabric8.kubernetes.api.builder.v4_10.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_10.apps.DeploymentStatus;
import io.fabric8.kubernetes.api.model.v4_10.apps.DeploymentStatusFluent;
import io.fabric8.kubernetes.api.model.v4_10.apps.DeploymentStatusFluentImpl;

public class DeploymentStatusBuilder
extends DeploymentStatusFluentImpl<DeploymentStatusBuilder>
implements VisitableBuilder<DeploymentStatus, DeploymentStatusBuilder> {
    DeploymentStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentStatusBuilder() {
        this(true);
    }

    public DeploymentStatusBuilder(Boolean validationEnabled) {
        this(new DeploymentStatus(), validationEnabled);
    }

    public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentStatus(), validationEnabled);
    }

    public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent, DeploymentStatus instance) {
        this(fluent, instance, true);
    }

    public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent, DeploymentStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAvailableReplicas(instance.getAvailableReplicas());
        fluent.withCollisionCount(instance.getCollisionCount());
        fluent.withConditions(instance.getConditions());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
        fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentStatusBuilder(DeploymentStatus instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentStatusBuilder(DeploymentStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withCollisionCount(instance.getCollisionCount());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUnavailableReplicas(instance.getUnavailableReplicas());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DeploymentStatus build() {
        DeploymentStatus buildable = new DeploymentStatus(this.fluent.getAvailableReplicas(), this.fluent.getCollisionCount(), this.fluent.getConditions(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas(), this.fluent.getUnavailableReplicas(), this.fluent.getUpdatedReplicas());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentStatusBuilder that = (DeploymentStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

