/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10;

import io.fabric8.kubernetes.api.model.v4_10.Status;
import io.fabric8.kubernetes.clnt.v4_10.OperationInfo;
import io.fabric8.kubernetes.clnt.v4_10.utils.Utils;

public class KubernetesClientException
extends RuntimeException {
    private int code;
    private Status status;

    public KubernetesClientException(String message) {
        super(message);
    }

    public KubernetesClientException(String message, Throwable t) {
        super(message, t);
    }

    public KubernetesClientException(Status status) {
        this(status.getMessage(), status.getCode(), status);
    }

    public KubernetesClientException(String message, int code, Status status) {
        super(message);
        this.code = code;
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public static RuntimeException launderThrowable(Throwable cause) {
        return KubernetesClientException.launderThrowable("An error has occurred.", cause);
    }

    public static RuntimeException launderThrowable(String message, Throwable cause) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw new KubernetesClientException(message, cause);
    }

    public static RuntimeException launderThrowable(OperationInfo spec, Throwable cause) {
        if (cause instanceof KubernetesClientException) {
            return KubernetesClientException.launderThrowable(spec, ((KubernetesClientException)cause).getStatus(), cause);
        }
        return KubernetesClientException.launderThrowable(KubernetesClientException.describeOperation(spec) + " failed.", cause);
    }

    public static RuntimeException launderThrowable(OperationInfo spec, Status status, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append(KubernetesClientException.describeOperation(spec) + " failed.");
        if (status != null && Utils.isNotNullOrEmpty(status.getMessage())) {
            sb.append("Reason: ").append(status.getMessage());
        }
        return KubernetesClientException.launderThrowable(sb.toString(), cause);
    }

    private static final String describeOperation(OperationInfo operation) {
        StringBuilder sb = new StringBuilder();
        sb.append("Operation");
        if (Utils.isNotNullOrEmpty(operation.getOperationType())) {
            sb.append(": [").append(operation.getOperationType() + "]");
        }
        sb.append(" ");
        sb.append(" for kind: [").append(operation.getKind()).append("] ");
        sb.append(" with name: [").append(operation.getName()).append("] ");
        sb.append(" in namespace: [").append(operation.getNamespace()).append("] ");
        return sb.toString();
    }
}

