/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_10.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.ListOptions;
import io.fabric8.kubernetes.api.model.v4_10.ResourceQuota;
import io.fabric8.kubernetes.api.model.v4_10.ResourceQuotaBuilder;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_10.dsl.internal.core.v1.ResourceQuotaOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ResourceQuotaHandler
implements ResourceHandler<ResourceQuota, ResourceQuotaBuilder> {
    @Override
    public String getKind() {
        return ResourceQuota.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public ResourceQuota create(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
        return (ResourceQuota)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ResourceQuota[0]);
    }

    @Override
    public ResourceQuota replace(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
        return (ResourceQuota)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ResourceQuota reload(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
        return (ResourceQuota)((Gettable)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ResourceQuotaBuilder edit(ResourceQuota item) {
        return new ResourceQuotaBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ResourceQuota item) {
        return (Boolean)new ResourceQuotaOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, Watcher<ResourceQuota> watcher) {
        return (Watch)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, String resourceVersion, Watcher<ResourceQuota> watcher) {
        return (Watch)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, ListOptions options, Watcher<ResourceQuota> watcher) {
        return (Watch)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ResourceQuota waitUntilReady(OkHttpClient client, Config config, String namespace, ResourceQuota item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ResourceQuota)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ResourceQuota waitUntilCondition(OkHttpClient client, Config config, String namespace, ResourceQuota item, Predicate<ResourceQuota> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ResourceQuota)((Resource)new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

