/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_10.handlers;

import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.ListOptions;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.openshift.api.model.v4_10.Image;
import io.fabric8.openshift.api.model.v4_10.ImageBuilder;
import io.fabric8.openshift.clnt.v4_10.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_10.dsl.internal.ImageOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageHandler
implements ResourceHandler<Image, ImageBuilder> {
    @Override
    public String getKind() {
        return Image.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    @Override
    public Image create(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Image[0]);
    }

    @Override
    public Image replace(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Image reload(OkHttpClient client, Config config, String namespace, Image item) {
        return (Image)((Gettable)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageBuilder edit(Image item) {
        return new ImageBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Image item) {
        return (Boolean)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, Watcher<Image> watcher) {
        return (Watch)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, String resourceVersion, Watcher<Image> watcher) {
        return (Watch)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Image item, ListOptions options, Watcher<Image> watcher) {
        return (Watch)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Image waitUntilReady(OkHttpClient client, Config config, String namespace, Image item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Image waitUntilCondition(OkHttpClient client, Config config, String namespace, Image item, Predicate<Image> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Image)((Resource)new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

