/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_10.handlers;

import io.fabric8.kubernetes.api.model.v4_10.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_10.ListOptions;
import io.fabric8.kubernetes.clnt.v4_10.Config;
import io.fabric8.kubernetes.clnt.v4_10.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_10.Watch;
import io.fabric8.kubernetes.clnt.v4_10.Watcher;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_10.dsl.Resource;
import io.fabric8.openshift.api.model.v4_10.Route;
import io.fabric8.openshift.api.model.v4_10.RouteBuilder;
import io.fabric8.openshift.clnt.v4_10.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_10.dsl.internal.RouteOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RouteHandler
implements ResourceHandler<Route, RouteBuilder> {
    @Override
    public String getKind() {
        return Route.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "route.openshift.io/v1";
    }

    @Override
    public Route create(OkHttpClient client, Config config, String namespace, Route item) {
        return (Route)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Route[0]);
    }

    @Override
    public Route replace(OkHttpClient client, Config config, String namespace, Route item) {
        return (Route)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Route reload(OkHttpClient client, Config config, String namespace, Route item) {
        return (Route)((Gettable)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RouteBuilder edit(Route item) {
        return new RouteBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Route item) {
        return (Boolean)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Route item, Watcher<Route> watcher) {
        return (Watch)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Route item, String resourceVersion, Watcher<Route> watcher) {
        return (Watch)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Route item, ListOptions options, Watcher<Route> watcher) {
        return (Watch)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Route waitUntilReady(OkHttpClient client, Config config, String namespace, Route item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Route)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Route waitUntilCondition(OkHttpClient client, Config config, String namespace, Route item, Predicate<Route> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Route)((Resource)new RouteOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

