/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.extensions.DeploymentCondition;
import io.fabric8.kubernetes.api.model.extensions.DeploymentConditionBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentConditionFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatus;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DeploymentStatusFluentImpl<A extends DeploymentStatusFluent<A>>
extends BaseFluent<A>
implements DeploymentStatusFluent<A> {
    private Integer availableReplicas;
    private Integer collisionCount;
    private List<DeploymentConditionBuilder> conditions = new ArrayList<DeploymentConditionBuilder>();
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private Integer unavailableReplicas;
    private Integer updatedReplicas;

    public DeploymentStatusFluentImpl() {
    }

    public DeploymentStatusFluentImpl(DeploymentStatus instance) {
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withCollisionCount(instance.getCollisionCount());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUnavailableReplicas(instance.getUnavailableReplicas());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
    }

    @Override
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    @Override
    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    @Override
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    @Override
    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    @Override
    public Boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    @Override
    public A addToConditions(int index, DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<DeploymentConditionBuilder>();
        }
        DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, DeploymentCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<DeploymentConditionBuilder>();
        }
        DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(DeploymentCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<DeploymentConditionBuilder>();
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<DeploymentCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<DeploymentConditionBuilder>();
        }
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(DeploymentCondition ... items) {
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<DeploymentCondition> items) {
        for (DeploymentCondition item : items) {
            DeploymentConditionBuilder builder = new DeploymentConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<DeploymentConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<DeploymentConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            DeploymentConditionBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeploymentCondition> getConditions() {
        return DeploymentStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<DeploymentCondition> buildConditions() {
        return DeploymentStatusFluentImpl.build(this.conditions);
    }

    @Override
    public DeploymentCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public DeploymentCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public DeploymentCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public DeploymentCondition buildMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        for (DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        for (DeploymentConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<DeploymentCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<DeploymentConditionBuilder>();
            for (DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(DeploymentCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (DeploymentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public DeploymentStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public DeploymentStatusFluent.ConditionsNested<A> addNewConditionLike(DeploymentCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public DeploymentStatusFluent.ConditionsNested<A> setNewConditionLike(int index, DeploymentCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public DeploymentStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DeploymentStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public DeploymentStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DeploymentStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DeploymentConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    @Override
    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    @Override
    public A withUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasUnavailableReplicas() {
        return this.unavailableReplicas != null;
    }

    @Override
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    @Override
    public A withUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedReplicas() {
        return this.updatedReplicas != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentStatusFluentImpl that = (DeploymentStatusFluentImpl)o;
        if (this.availableReplicas != null ? !this.availableReplicas.equals(that.availableReplicas) : that.availableReplicas != null) {
            return false;
        }
        if (this.collisionCount != null ? !this.collisionCount.equals(that.collisionCount) : that.collisionCount != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.readyReplicas != null ? !this.readyReplicas.equals(that.readyReplicas) : that.readyReplicas != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.unavailableReplicas != null ? !this.unavailableReplicas.equals(that.unavailableReplicas) : that.unavailableReplicas != null) {
            return false;
        }
        return !(this.updatedReplicas != null ? !this.updatedReplicas.equals(that.updatedReplicas) : that.updatedReplicas != null);
    }

    public class ConditionsNestedImpl<N>
    extends DeploymentConditionFluentImpl<DeploymentStatusFluent.ConditionsNested<N>>
    implements DeploymentStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final DeploymentConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, DeploymentCondition item) {
            this.index = index;
            this.builder = new DeploymentConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new DeploymentConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

