/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicy;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyFluentImpl;

public class NetworkPolicyBuilder
extends NetworkPolicyFluentImpl<NetworkPolicyBuilder>
implements VisitableBuilder<NetworkPolicy, NetworkPolicyBuilder> {
    NetworkPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicyBuilder() {
        this(true);
    }

    public NetworkPolicyBuilder(Boolean validationEnabled) {
        this(new NetworkPolicy(), validationEnabled);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicy(), validationEnabled);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent, NetworkPolicy instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyBuilder(NetworkPolicyFluent<?> fluent, NetworkPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyBuilder(NetworkPolicy instance) {
        this(instance, (Boolean)true);
    }

    public NetworkPolicyBuilder(NetworkPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkPolicy build() {
        NetworkPolicy buildable = new NetworkPolicy(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyBuilder that = (NetworkPolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

