/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DoneableBuild;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.internal.BuildOperationContext;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BuildOperationsImpl
extends OpenShiftOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>>
implements BuildResource<Build, DoneableBuild, String, LogWatch> {
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final PipedOutputStream inPipe;
    private final PipedInputStream outPipe;
    private final PipedInputStream errPipe;
    private final boolean withTTY;
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final String version;
    private final Integer limitBytes;

    public BuildOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new BuildOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public BuildOperationsImpl(BuildOperationContext context) {
        super(context.withApiGroupName("build.openshift.io").withPlural("builds"));
        this.type = Build.class;
        this.listType = BuildList.class;
        this.doneableType = DoneableBuild.class;
        this.in = context.getIn();
        this.out = context.getOut();
        this.err = context.getErr();
        this.inPipe = context.getInPipe();
        this.outPipe = context.getOutPipe();
        this.errPipe = context.getErrPipe();
        this.withTTY = context.isTty();
        this.withTerminatedStatus = context.isTerminatedStatus();
        this.withTimestamps = context.isTimestamps();
        this.sinceTimestamp = context.getSinceTimestamp();
        this.sinceSeconds = context.getSinceSeconds();
        this.withTailingLines = context.getTailingLines();
        this.withPrettyOutput = context.isPrettyOutput();
        this.version = context.getVersion();
        this.limitBytes = context.getLimitBytes();
    }

    public BuildOperationsImpl newInstance(OperationContext context) {
        return new BuildOperationsImpl((BuildOperationContext)context);
    }

    BuildOperationContext getContext() {
        return (BuildOperationContext)this.context;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.version != null && !this.version.isEmpty()) {
            sb.append("&version=").append(this.version);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        if (this.withTimestamps) {
            sb.append("&timestamps=true");
        }
        return sb.toString();
    }

    protected ResponseBody doGetLog() {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters()));
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            ResponseBody body = response.body();
            this.assertResponseCode(request, response);
            return body;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("doGetLog"), t);
        }
    }

    @Override
    public String getLog() {
        String string;
        block8: {
            ResponseBody body = this.doGetLog();
            try {
                string = this.doGetLog().string();
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw KubernetesClientException.launderThrowable(this.forOperationType("getLog"), (Throwable)e);
                }
            }
            body.close();
        }
        return string;
    }

    @Override
    public String getLog(Boolean isPretty) {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(isPretty)).getLog();
    }

    @Override
    public Reader getLogReader() {
        return this.doGetLog().charStream();
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"));
            Request request = new Request.Builder().url(url).get().build();
            LogWatchCallback callback = new LogWatchCallback(out);
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue((Callback)callback);
            callback.waitUntilReady();
            return callback;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), t);
        }
    }

    @Override
    public Loggable<String, LogWatch> withPrettyOutput() {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(true));
    }

    @Override
    public PrettyLoggable<String, LogWatch> tailingLines(int tailingLines) {
        return new BuildOperationsImpl(this.getContext().withTailingLines(tailingLines));
    }

    @Override
    public TimeTailPrettyLoggable<String, LogWatch> terminated() {
        return new BuildOperationsImpl(this.getContext().withTerminatedStatus(true));
    }

    @Override
    public TailPrettyLoggable<String, LogWatch> sinceTime(String sinceTimestamp) {
        return new BuildOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp));
    }

    @Override
    public TailPrettyLoggable<String, LogWatch> sinceSeconds(int sinceSeconds) {
        return new BuildOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds));
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<String, LogWatch> limitBytes(int limitBytes) {
        return new BuildOperationsImpl(this.getContext().withLimitBytes(limitBytes));
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<String, LogWatch> usingTimestamps() {
        return new BuildOperationsImpl(this.getContext().withTimestamps(true));
    }
}

