/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PodExecOptions;
import io.fabric8.kubernetes.api.model.PodExecOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PodExecOptionsFluentImpl<A extends PodExecOptionsFluent<A>>
extends BaseFluent<A>
implements PodExecOptionsFluent<A> {
    private String apiVersion;
    private List<String> command = new ArrayList<String>();
    private String container;
    private String kind;
    private Boolean stderr;
    private Boolean stdin;
    private Boolean stdout;
    private Boolean tty;

    public PodExecOptionsFluentImpl() {
    }

    public PodExecOptionsFluentImpl(PodExecOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withCommand(instance.getCommand());
        this.withContainer(instance.getContainer());
        this.withKind(instance.getKind());
        this.withStderr(instance.getStderr());
        this.withStdin(instance.getStdin());
        this.withStdout(instance.getStdout());
        this.withTty(instance.getTty());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCommand(List<String> command) {
        if (this.command != null) {
            this._visitables.get("command").removeAll(this.command);
        }
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A addNewCommand(String arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A addNewCommand(StringBuilder arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A addNewCommand(StringBuffer arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    public A withNewContainer(String arg1) {
        return this.withContainer(new String(arg1));
    }

    @Override
    public A withNewContainer(StringBuilder arg1) {
        return this.withContainer(new String(arg1));
    }

    @Override
    public A withNewContainer(StringBuffer arg1) {
        return this.withContainer(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public Boolean isStderr() {
        return this.stderr;
    }

    @Override
    public A withStderr(Boolean stderr) {
        this.stderr = stderr;
        return (A)this;
    }

    @Override
    public Boolean hasStderr() {
        return this.stderr != null;
    }

    @Override
    public A withNewStderr(String arg1) {
        return this.withStderr(new Boolean(arg1));
    }

    @Override
    public A withNewStderr(boolean arg1) {
        return this.withStderr(new Boolean(arg1));
    }

    @Override
    public Boolean isStdin() {
        return this.stdin;
    }

    @Override
    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    @Override
    public Boolean hasStdin() {
        return this.stdin != null;
    }

    @Override
    public A withNewStdin(String arg1) {
        return this.withStdin(new Boolean(arg1));
    }

    @Override
    public A withNewStdin(boolean arg1) {
        return this.withStdin(new Boolean(arg1));
    }

    @Override
    public Boolean isStdout() {
        return this.stdout;
    }

    @Override
    public A withStdout(Boolean stdout) {
        this.stdout = stdout;
        return (A)this;
    }

    @Override
    public Boolean hasStdout() {
        return this.stdout != null;
    }

    @Override
    public A withNewStdout(String arg1) {
        return this.withStdout(new Boolean(arg1));
    }

    @Override
    public A withNewStdout(boolean arg1) {
        return this.withStdout(new Boolean(arg1));
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    @Override
    public Boolean hasTty() {
        return this.tty != null;
    }

    @Override
    public A withNewTty(String arg1) {
        return this.withTty(new Boolean(arg1));
    }

    @Override
    public A withNewTty(boolean arg1) {
        return this.withTty(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodExecOptionsFluentImpl that = (PodExecOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.container != null ? !this.container.equals(that.container) : that.container != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.stderr != null ? !this.stderr.equals(that.stderr) : that.stderr != null) {
            return false;
        }
        if (this.stdin != null ? !this.stdin.equals(that.stdin) : that.stdin != null) {
            return false;
        }
        if (this.stdout != null ? !this.stdout.equals(that.stdout) : that.stdout != null) {
            return false;
        }
        return !(this.tty != null ? !this.tty.equals(that.tty) : that.tty != null);
    }
}

