/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyFluent;
import io.fabric8.openshift.api.model.ProxyFluentImpl;

public class ProxyBuilder
extends ProxyFluentImpl<ProxyBuilder>
implements VisitableBuilder<Proxy, ProxyBuilder> {
    ProxyFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyBuilder() {
        this(true);
    }

    public ProxyBuilder(Boolean validationEnabled) {
        this(new Proxy(), validationEnabled);
    }

    public ProxyBuilder(ProxyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProxyBuilder(ProxyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Proxy(), validationEnabled);
    }

    public ProxyBuilder(ProxyFluent<?> fluent, Proxy instance) {
        this(fluent, instance, true);
    }

    public ProxyBuilder(ProxyFluent<?> fluent, Proxy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ProxyBuilder(Proxy instance) {
        this(instance, (Boolean)true);
    }

    public ProxyBuilder(Proxy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Proxy build() {
        Proxy buildable = new Proxy(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProxyBuilder that = (ProxyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

