/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.KuryrConfig;
import io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluent;
import io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluentImpl;

public class KuryrConfigBuilder
extends KuryrConfigFluentImpl<KuryrConfigBuilder>
implements VisitableBuilder<KuryrConfig, KuryrConfigBuilder> {
    KuryrConfigFluent<?> fluent;
    Boolean validationEnabled;

    public KuryrConfigBuilder() {
        this(true);
    }

    public KuryrConfigBuilder(Boolean validationEnabled) {
        this(new KuryrConfig(), validationEnabled);
    }

    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KuryrConfig(), validationEnabled);
    }

    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent, KuryrConfig instance) {
        this(fluent, instance, true);
    }

    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent, KuryrConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withControllerProbesPort(instance.getControllerProbesPort());
        fluent.withDaemonProbesPort(instance.getDaemonProbesPort());
        fluent.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation());
        fluent.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork());
        fluent.withPoolBatchPorts(instance.getPoolBatchPorts());
        fluent.withPoolMaxPorts(instance.getPoolMaxPorts());
        fluent.withPoolMinPorts(instance.getPoolMinPorts());
        this.validationEnabled = validationEnabled;
    }

    public KuryrConfigBuilder(KuryrConfig instance) {
        this(instance, (Boolean)true);
    }

    public KuryrConfigBuilder(KuryrConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withControllerProbesPort(instance.getControllerProbesPort());
        this.withDaemonProbesPort(instance.getDaemonProbesPort());
        this.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation());
        this.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork());
        this.withPoolBatchPorts(instance.getPoolBatchPorts());
        this.withPoolMaxPorts(instance.getPoolMaxPorts());
        this.withPoolMinPorts(instance.getPoolMinPorts());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KuryrConfig build() {
        KuryrConfig buildable = new KuryrConfig(this.fluent.getControllerProbesPort(), this.fluent.getDaemonProbesPort(), this.fluent.isEnablePortPoolsPrepopulation(), this.fluent.getOpenStackServiceNetwork(), this.fluent.getPoolBatchPorts(), this.fluent.getPoolMaxPorts(), this.fluent.getPoolMinPorts());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KuryrConfigBuilder that = (KuryrConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

