/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OperationContext {
    protected OkHttpClient client;
    protected Config config;
    protected Object item;
    protected String resourceVersion;
    protected String plural;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected String namespace;
    protected String name;
    protected boolean cascading;
    protected boolean reloadingFromServer;
    protected boolean namespaceFromGlobalConfig;
    protected long gracePeriodSeconds = -1L;
    protected DeletionPropagation propagationPolicy;
    protected long watchRetryInitialBackoffMillis = 5L;
    protected double watchRetryBackoffMultiplier = 2.0;
    protected Map<String, String> labels;
    protected Map<String, String[]> labelsNot;
    protected Map<String, String[]> labelsIn;
    protected Map<String, String[]> labelsNotIn;
    protected Map<String, String> fields;
    protected Map<String, String[]> fieldsNot;

    public OperationContext() {
    }

    public OperationContext(OkHttpClient client, Config config, String plural, String namespace, String name, String apiGroupName, String apiGroupVersion, boolean cascading, Object item, Map<String, String> labels, Map<String, String[]> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Map<String, String[]> fieldsNot, String resourceVersion, boolean reloadingFromServer, long gracePeriodSeconds, DeletionPropagation propagationPolicy, long watchRetryInitialBackoffMillis, double watchRetryBackoffMultiplier, boolean namespaceFromGlobalConfig) {
        this.client = client;
        this.config = config;
        this.plural = plural;
        this.name = name;
        this.cascading = cascading;
        this.labels = labels != null ? labels : new HashMap();
        this.labelsNot = labelsNot != null ? labelsNot : new HashMap();
        this.labelsIn = labelsIn != null ? labelsIn : new HashMap();
        this.labelsNotIn = labelsNotIn != null ? labelsNotIn : new HashMap();
        this.fields = fields != null ? fields : new HashMap();
        this.fieldsNot = fieldsNot != null ? fieldsNot : new HashMap();
        this.resourceVersion = resourceVersion;
        this.reloadingFromServer = reloadingFromServer;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.watchRetryInitialBackoffMillis = watchRetryInitialBackoffMillis;
        this.watchRetryBackoffMultiplier = watchRetryBackoffMultiplier;
        this.item = item;
        this.apiGroupName = ApiVersionUtil.apiGroup(item, apiGroupName);
        this.apiGroupVersion = ApiVersionUtil.apiVersion(item, apiGroupVersion);
        this.namespace = Utils.isNotNullOrEmpty(namespace) ? namespace : (config != null ? config.getNamespace() : null);
        this.namespaceFromGlobalConfig = namespaceFromGlobalConfig;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getApiGroupName() {
        return this.apiGroupName;
    }

    public String getApiGroupVersion() {
        return this.apiGroupVersion;
    }

    public boolean getCascading() {
        return this.cascading;
    }

    public Object getItem() {
        return this.item;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String[]> getLabelsNot() {
        return this.labelsNot;
    }

    public Map<String, String[]> getLabelsIn() {
        return this.labelsIn;
    }

    public Map<String, String[]> getLabelsNotIn() {
        return this.labelsNotIn;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Map<String, String[]> getFieldsNot() {
        return this.fieldsNot;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public boolean getReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public DeletionPropagation getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public long getWatchRetryInitialBackoffMillis() {
        return this.watchRetryInitialBackoffMillis;
    }

    public double getWatchRetryBackoffMultiplier() {
        return this.watchRetryBackoffMultiplier;
    }

    public boolean isNamespaceFromGlobalConfig() {
        return this.namespaceFromGlobalConfig;
    }

    public OperationContext withOkhttpClient(OkHttpClient client) {
        return new OperationContext(client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withConfig(Config config) {
        return new OperationContext(this.client, config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withPlural(String plural) {
        return new OperationContext(this.client, this.config, plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withNamespace(String namespace) {
        return new OperationContext(this.client, this.config, this.plural, namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withName(String name) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withApiGroupName(String apiGroupName) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withApiGroupVersion(String apiGroupVersion) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withItem(Object item) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withCascading(boolean cascading) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withLabels(Map<String, String> labels) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withLabelsIn(Map<String, String[]> labelsIn) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withLabelsNot(Map<String, String[]> labelsNot) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withLabelsNotIn(Map<String, String[]> labelsNotIn) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withFields(Map<String, String> fields) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withFieldsNot(Map<String, String[]> fieldsNot) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withResourceVersion(String resourceVersion) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withReloadingFromServer(boolean reloadingFromServer) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withGracePeriodSeconds(long gracePeriodSeconds) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withWatchRetryInitialBackoffMillis(long watchRetryInitialBackoffMillis) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withWatchRetryBackoffMultiplier(double watchRetryBackoffMultiplier) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, watchRetryBackoffMultiplier, this.namespaceFromGlobalConfig);
    }

    public OperationContext withIsNamespaceConfiguredFromGlobalConfig(boolean namespaceFromGlobalConfig) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.watchRetryInitialBackoffMillis, this.watchRetryBackoffMultiplier, namespaceFromGlobalConfig);
    }

    public OperationContext withOperationContext(OperationContext operationContext) {
        OkHttpClient clientCloned = this.getClient();
        Config configCloned = this.getConfig();
        Object itemCloned = this.getItem();
        String resourceVersionCloned = this.getResourceVersion();
        String pluralCloned = this.getPlural();
        String apiGroupNameCloned = this.getApiGroupName();
        String apiGroupVersionCloned = this.getApiGroupVersion();
        String namespaceCloned = this.getNamespace();
        String nameCloned = this.getName();
        boolean cascadingCloned = this.getCascading();
        boolean reloadingFromServerCloned = this.getReloadingFromServer();
        boolean namespaceFromGlobalConfigCloned = this.isNamespaceFromGlobalConfig();
        long gracePeriodSecondsCloned = this.getGracePeriodSeconds();
        long watchRetryInitialBackoffMillis = this.getWatchRetryInitialBackoffMillis();
        double watchRetryBackoffMultiplier = this.getWatchRetryBackoffMultiplier();
        DeletionPropagation propagationPolicyCloned = this.getPropagationPolicy();
        Map<String, String> labelsCloned = this.getLabels();
        Map<String, String[]> labelsNotCloned = this.getLabelsNot();
        Map<String, String[]> labelsInCloned = this.getLabelsIn();
        Map<String, String[]> labelsNotInCloned = this.getLabelsNotIn();
        Map<String, String> fieldsCloned = this.getFields();
        Map<String, String[]> fieldsNotCloned = this.getFieldsNot();
        if (operationContext.getApiGroupVersion() != null) {
            apiGroupVersionCloned = operationContext.getApiGroupVersion();
        }
        if (operationContext.getClient() != null) {
            clientCloned = operationContext.getClient();
        }
        if (operationContext.getConfig() != null) {
            configCloned = operationContext.getConfig();
        }
        if (operationContext.getPlural() != null) {
            pluralCloned = operationContext.getPlural();
        }
        if (operationContext.getNamespace() != null) {
            namespaceCloned = operationContext.getNamespace();
        }
        if (operationContext.getName() != null) {
            nameCloned = operationContext.getName();
        }
        if (operationContext.getApiGroupName() != null) {
            apiGroupNameCloned = operationContext.getApiGroupName();
        }
        if (operationContext.getCascading()) {
            cascadingCloned = operationContext.getCascading();
        }
        if (operationContext.getItem() != null) {
            itemCloned = operationContext.getItem();
        }
        if (operationContext.getLabels() != null) {
            labelsCloned = operationContext.getLabels();
        }
        if (operationContext.getLabelsNot() != null) {
            labelsNotCloned = operationContext.getLabelsNot();
        }
        if (operationContext.getLabelsIn() != null) {
            labelsInCloned = operationContext.getLabelsIn();
        }
        if (operationContext.getLabelsNotIn() != null) {
            labelsNotInCloned = operationContext.getLabelsNotIn();
        }
        if (operationContext.getFields() != null) {
            fieldsCloned = operationContext.getFields();
        }
        if (operationContext.getFieldsNot() != null) {
            fieldsNotCloned = operationContext.getFieldsNot();
        }
        if (operationContext.getResourceVersion() != null) {
            resourceVersionCloned = operationContext.getResourceVersion();
        }
        if (operationContext.getReloadingFromServer()) {
            reloadingFromServerCloned = operationContext.getReloadingFromServer();
        }
        if (operationContext.getGracePeriodSeconds() > 0L) {
            gracePeriodSecondsCloned = operationContext.getGracePeriodSeconds();
        }
        if (operationContext.getPropagationPolicy() != null) {
            propagationPolicyCloned = operationContext.getPropagationPolicy();
        }
        namespaceFromGlobalConfigCloned = operationContext.isNamespaceFromGlobalConfig();
        return new OperationContext(clientCloned, configCloned, pluralCloned, namespaceCloned, nameCloned, apiGroupNameCloned, apiGroupVersionCloned, cascadingCloned, itemCloned, labelsCloned, labelsNotCloned, labelsInCloned, labelsNotInCloned, fieldsCloned, fieldsNotCloned, resourceVersionCloned, reloadingFromServerCloned, gracePeriodSecondsCloned, propagationPolicyCloned, watchRetryInitialBackoffMillis, watchRetryBackoffMultiplier, namespaceFromGlobalConfigCloned);
    }
}

