/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.APIGroupFluent;
import io.fabric8.kubernetes.api.model.APIGroupFluentImpl;
import javax.validation.Validator;

public class APIGroupBuilder
extends APIGroupFluentImpl<APIGroupBuilder>
implements VisitableBuilder<APIGroup, APIGroupBuilder> {
    APIGroupFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public APIGroupBuilder() {
        this(true);
    }

    public APIGroupBuilder(Boolean validationEnabled) {
        this(new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance) {
        this(fluent, instance, true);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withPreferredVersion(instance.getPreferredVersion());
        fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        fluent.withVersions(instance.getVersions());
        this.validationEnabled = validationEnabled;
    }

    public APIGroupBuilder(APIGroup instance) {
        this(instance, (Boolean)true);
    }

    public APIGroupBuilder(APIGroup instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withPreferredVersion(instance.getPreferredVersion());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
        this.validationEnabled = validationEnabled;
    }

    public APIGroupBuilder(Validator validator) {
        this(new APIGroup(), (Boolean)true);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withPreferredVersion(instance.getPreferredVersion());
        fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        fluent.withVersions(instance.getVersions());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public APIGroupBuilder(APIGroup instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withPreferredVersion(instance.getPreferredVersion());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public APIGroup build() {
        APIGroup buildable = new APIGroup(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getPreferredVersion(), this.fluent.getServerAddressByClientCIDRs(), this.fluent.getVersions());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIGroupBuilder that = (APIGroupBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

