/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers;

import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.HorizontalPodAutoscalerOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class HorizontalPodAutoscalerHandler
implements ResourceHandler<HorizontalPodAutoscaler, HorizontalPodAutoscalerBuilder> {
    @Override
    public String getKind() {
        return HorizontalPodAutoscaler.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "autoscaling/v1";
    }

    @Override
    public HorizontalPodAutoscaler create(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item) {
        return (HorizontalPodAutoscaler)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new HorizontalPodAutoscaler[0]);
    }

    @Override
    public HorizontalPodAutoscaler replace(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item) {
        return (HorizontalPodAutoscaler)((Resource)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public HorizontalPodAutoscaler reload(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item) {
        return (HorizontalPodAutoscaler)((Gettable)((Resource)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public HorizontalPodAutoscalerBuilder edit(HorizontalPodAutoscaler item) {
        return new HorizontalPodAutoscalerBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, HorizontalPodAutoscaler item) {
        if (cascading.booleanValue()) {
            return (Boolean)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
        }
        return (Boolean)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, Watcher<HorizontalPodAutoscaler> watcher) {
        return (Watch)((Resource)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, String resourceVersion, Watcher<HorizontalPodAutoscaler> watcher) {
        return (Watch)((Resource)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public HorizontalPodAutoscaler waitUntilReady(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (HorizontalPodAutoscaler)((Resource)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public HorizontalPodAutoscaler waitUntilCondition(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, Predicate<HorizontalPodAutoscaler> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (HorizontalPodAutoscaler)((Resource)new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

