/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.StepInfo;
import io.fabric8.openshift.api.model.StepInfoFluent;
import io.fabric8.openshift.api.model.StepInfoFluentImpl;
import javax.validation.Validator;

public class StepInfoBuilder
extends StepInfoFluentImpl<StepInfoBuilder>
implements VisitableBuilder<StepInfo, StepInfoBuilder> {
    StepInfoFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StepInfoBuilder() {
        this(true);
    }

    public StepInfoBuilder(Boolean validationEnabled) {
        this(new StepInfo(), validationEnabled);
    }

    public StepInfoBuilder(StepInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StepInfoBuilder(StepInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StepInfo(), validationEnabled);
    }

    public StepInfoBuilder(StepInfoFluent<?> fluent, StepInfo instance) {
        this(fluent, instance, true);
    }

    public StepInfoBuilder(StepInfoFluent<?> fluent, StepInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDurationMilliseconds(instance.getDurationMilliseconds());
        fluent.withName(instance.getName());
        fluent.withStartTime(instance.getStartTime());
        this.validationEnabled = validationEnabled;
    }

    public StepInfoBuilder(StepInfo instance) {
        this(instance, (Boolean)true);
    }

    public StepInfoBuilder(StepInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDurationMilliseconds(instance.getDurationMilliseconds());
        this.withName(instance.getName());
        this.withStartTime(instance.getStartTime());
        this.validationEnabled = validationEnabled;
    }

    public StepInfoBuilder(Validator validator) {
        this(new StepInfo(), (Boolean)true);
    }

    public StepInfoBuilder(StepInfoFluent<?> fluent, StepInfo instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDurationMilliseconds(instance.getDurationMilliseconds());
        fluent.withName(instance.getName());
        fluent.withStartTime(instance.getStartTime());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StepInfoBuilder(StepInfo instance, Validator validator) {
        this.fluent = this;
        this.withDurationMilliseconds(instance.getDurationMilliseconds());
        this.withName(instance.getName());
        this.withStartTime(instance.getStartTime());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public StepInfo build() {
        StepInfo buildable = new StepInfo(this.fluent.getDurationMilliseconds(), this.fluent.getName(), this.fluent.getStartTime());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StepInfoBuilder that = (StepInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

