/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.RawWatchConnectionManager;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.WatcherToggle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RawCustomResourceOperationsImpl
extends OperationSupport {
    private OkHttpClient client;
    private Config config;
    private CustomResourceDefinitionContext customResourceDefinition;
    private ObjectMapper objectMapper;

    public RawCustomResourceOperationsImpl(OkHttpClient client, Config config, CustomResourceDefinitionContext customResourceDefinition) {
        this.client = client;
        this.config = config;
        this.customResourceDefinition = customResourceDefinition;
        this.objectMapper = Serialization.jsonMapper();
    }

    public Map<String, Object> load(InputStream fileInputStream) throws IOException {
        return this.convertJsonOrYamlStringToMap(IOHelpers.readFully(fileInputStream));
    }

    public Map<String, Object> load(String objectAsJsonString) throws IOException {
        return this.convertJsonOrYamlStringToMap(objectAsJsonString);
    }

    public Map<String, Object> create(String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(null, null, objectAsString, HttpCallMethod.POST);
    }

    public Map<String, Object> create(Map<String, Object> object) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(null, null, this.objectMapper.writeValueAsString(object), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, String objectAsString) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(namespace, null, objectAsString, HttpCallMethod.POST);
    }

    public Map<String, Object> create(InputStream objectAsStream) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(null, null, IOHelpers.readFully(objectAsStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, InputStream objectAsStream) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(namespace, null, IOHelpers.readFully(objectAsStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String namespace, Map<String, Object> object) throws KubernetesClientException, IOException {
        return this.validateAndSubmitRequest(namespace, null, this.objectMapper.writeValueAsString(object), HttpCallMethod.POST);
    }

    public Map<String, Object> createOrReplace(String objectAsString) throws IOException {
        return this.createOrReplaceJsonStringObject(null, objectAsString);
    }

    public Map<String, Object> createOrReplace(Map<String, Object> customResourceObject) throws IOException {
        return this.createOrReplace(this.objectMapper.writeValueAsString(customResourceObject));
    }

    public Map<String, Object> createOrReplace(InputStream inputStream) throws IOException {
        return this.createOrReplace(IOHelpers.readFully(inputStream));
    }

    public Map<String, Object> createOrReplace(String namespace, String objectAsString) throws IOException {
        return this.createOrReplaceJsonStringObject(namespace, objectAsString);
    }

    public Map<String, Object> createOrReplace(String namespace, Map<String, Object> customResourceObject) throws IOException {
        return this.createOrReplace(namespace, this.objectMapper.writeValueAsString(customResourceObject));
    }

    public Map<String, Object> createOrReplace(String namespace, InputStream objectAsString) throws IOException {
        return this.createOrReplace(namespace, IOHelpers.readFully(objectAsString));
    }

    public Map<String, Object> edit(String name, Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(null, name, this.objectMapper.writeValueAsString(object), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String name, String objectAsString) throws IOException {
        return this.validateAndSubmitRequest(null, name, objectAsString, HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, Map<String, Object> object) throws IOException {
        return this.validateAndSubmitRequest(namespace, name, this.objectMapper.writeValueAsString(object), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, String objectAsString) throws IOException {
        objectAsString = this.appendResourceVersionInObject(namespace, name, objectAsString);
        return this.validateAndSubmitRequest(namespace, name, objectAsString, HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String name, InputStream objectAsStream) throws IOException, KubernetesClientException {
        return this.validateAndSubmitRequest(null, name, IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> edit(String namespace, String name, InputStream objectAsStream) throws IOException, KubernetesClientException {
        return this.validateAndSubmitRequest(namespace, name, IOHelpers.readFully(objectAsStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> get(String name) {
        return this.makeCall(this.fetchUrl(null, null) + name, null, HttpCallMethod.GET);
    }

    public Map<String, Object> get(String namespace, String name) {
        return this.makeCall(this.fetchUrl(namespace, null) + name, null, HttpCallMethod.GET);
    }

    public Map<String, Object> list() {
        return this.makeCall(this.fetchUrl(null, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String namespace) {
        return this.makeCall(this.fetchUrl(namespace, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String namespace, Map<String, String> labels) {
        return this.makeCall(this.fetchUrl(namespace, labels), null, HttpCallMethod.GET);
    }

    public Map<String, Object> delete(String namespace) {
        return this.makeCall(this.fetchUrl(namespace, null), null, HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, boolean cascading) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(cascading, null)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, DeleteOptions deleteOptions) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, null), this.objectMapper.writeValueAsString((Object)deleteOptions), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name) {
        return this.makeCall(this.fetchUrl(namespace, null) + name, null, HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name, boolean cascading) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, null) + name, this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(cascading, null)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name, String propagationPolicy) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, null) + name, this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(false, propagationPolicy)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String namespace, String name, DeleteOptions deleteOptions) throws IOException {
        return this.makeCall(this.fetchUrl(namespace, null) + name, this.objectMapper.writeValueAsString((Object)deleteOptions), HttpCallMethod.DELETE);
    }

    public void watch(String namespace, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, null, watcher);
    }

    public void watch(String namespace, String resourceVersion, Watcher<String> watcher) throws IOException {
        this.watch(namespace, null, null, resourceVersion, watcher);
    }

    public void watch(Watcher<String> watcher) throws IOException {
        this.watch(null, null, null, null, watcher);
    }

    public Watch watch(String namespace, String name, Map<String, String> labels, String resourceVersion, Watcher<String> watcher) throws IOException {
        URL url = new URL(this.fetchUrl(name, namespace, labels));
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get((URL)url).newBuilder();
        if (resourceVersion != null) {
            httpUrlBuilder.addQueryParameter("resourceVersion", resourceVersion);
        }
        httpUrlBuilder.addQueryParameter("watch", "true");
        String origin = url.getProtocol() + "://" + url.getHost();
        if (url.getPort() != -1) {
            origin = origin + ":" + url.getPort();
        }
        Request request = new Request.Builder().get().url(httpUrlBuilder.build()).addHeader("Origin", origin).build();
        OkHttpClient.Builder clonedClientBuilder = this.client.newBuilder();
        clonedClientBuilder.readTimeout(this.getConfig() != null ? this.getConfig().getWebsocketTimeout() : Config.DEFAULT_WEBSOCKET_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
        clonedClientBuilder.pingInterval(this.getConfig() != null ? this.getConfig().getWebsocketPingInterval() : Config.DEFAULT_WEBSOCKET_PING_INTERVAL.longValue(), TimeUnit.MILLISECONDS);
        OkHttpClient clonedOkHttpClient = clonedClientBuilder.build();
        WatcherToggle<String> watcherToggle = new WatcherToggle<String>(watcher, true);
        RawWatchConnectionManager watch = null;
        try {
            watch = new RawWatchConnectionManager(clonedOkHttpClient, request, resourceVersion, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
            watch.waitUntilReady();
            return watch;
        }
        catch (KubernetesClientException ke) {
            if (ke.getCode() != 200) {
                if (watch != null) {
                    watch.close();
                }
                throw ke;
            }
            if (watch != null) {
                watcherToggle.disable();
                watch.close();
            }
            return new RawWatchConnectionManager(clonedOkHttpClient, request, resourceVersion, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
        }
    }

    private Map<String, Object> createOrReplaceJsonStringObject(String namespace, String objectAsString) throws IOException {
        Map<String, Object> ret;
        try {
            ret = namespace != null ? this.create(namespace, objectAsString) : this.create(objectAsString);
        }
        catch (KubernetesClientException exception) {
            try {
                Map<String, Object> objectMap = this.load(objectAsString);
                String name = ((Map)objectMap.get("metadata")).get("name").toString();
                ret = namespace != null ? this.edit(namespace, name, objectAsString) : this.edit(name, objectAsString);
            }
            catch (NullPointerException nullPointerException) {
                throw KubernetesClientException.launderThrowable(new IllegalStateException("Invalid json string provided."));
            }
        }
        return ret;
    }

    private Map<String, Object> convertJsonOrYamlStringToMap(String objectAsString) throws IOException {
        HashMap retVal = null;
        retVal = IOHelpers.isJSONValid(objectAsString) ? (HashMap)this.objectMapper.readValue(objectAsString, HashMap.class) : (HashMap)this.objectMapper.readValue(IOHelpers.convertYamlToJson(objectAsString), HashMap.class);
        return retVal;
    }

    private String fetchUrl(String name, String namespace, Map<String, String> labels) {
        String url = this.fetchUrl(namespace, labels);
        if (name != null) {
            return url + name;
        }
        return url.substring(0, url.length() - 1);
    }

    private String fetchUrl(String namespace, Map<String, String> labels) {
        if (this.config.getMasterUrl() == null) {
            return null;
        }
        StringBuilder urlBuilder = new StringBuilder(this.config.getMasterUrl());
        urlBuilder.append(this.config.getMasterUrl().endsWith("/") ? "" : "/");
        urlBuilder.append("apis/").append(this.customResourceDefinition.getGroup()).append("/").append(this.customResourceDefinition.getVersion()).append("/");
        if (this.customResourceDefinition.getScope().equals("Namespaced") && namespace != null) {
            urlBuilder.append("namespaces/").append(namespace).append("/");
        }
        urlBuilder.append(this.customResourceDefinition.getPlural()).append("/");
        if (labels != null) {
            urlBuilder.deleteCharAt(urlBuilder.lastIndexOf("/"));
            urlBuilder.append("?labelSelector").append("=").append(this.getLabelsQueryParam(labels));
        }
        return urlBuilder.toString();
    }

    private String getLabelsQueryParam(Map<String, String> labels) {
        StringBuilder labelQueryBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (labelQueryBuilder.length() > 0) {
                labelQueryBuilder.append(",");
            }
            labelQueryBuilder.append(entry.getKey()).append(Utils.toUrlEncoded("=")).append(entry.getValue());
        }
        return labelQueryBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> makeCall(String url, String body, HttpCallMethod callMethod) {
        Request request = body == null ? this.getRequest(url, callMethod) : this.getRequest(url, body, callMethod);
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                Map map = (Map)this.objectMapper.readValue(response.body().string(), HashMap.class);
                return map;
            }
            throw RawCustomResourceOperationsImpl.requestFailure(request, RawCustomResourceOperationsImpl.createStatus(response));
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private Map<String, Object> validateAndSubmitRequest(String namespace, String name, String objectAsString, HttpCallMethod httpCallMethod) throws IOException {
        if (IOHelpers.isJSONValid(objectAsString)) {
            return this.makeCall(this.fetchUrl(namespace, null) + (name != null ? name : ""), objectAsString, httpCallMethod);
        }
        return this.makeCall(this.fetchUrl(namespace, null) + (name != null ? name : ""), IOHelpers.convertYamlToJson(objectAsString), httpCallMethod);
    }

    private Request getRequest(String url, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        switch (httpCallMethod) {
            case GET: {
                requestBuilder.get().url(url);
                break;
            }
            case DELETE: {
                requestBuilder.delete().url(url);
            }
        }
        return requestBuilder.build();
    }

    private Request getRequest(String url, String body, HttpCallMethod httpCallMethod) {
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body);
        switch (httpCallMethod) {
            case DELETE: {
                return requestBuilder.delete(requestBody).url(url).build();
            }
            case POST: {
                return requestBuilder.post(requestBody).url(url).build();
            }
            case PUT: {
                return requestBuilder.put(requestBody).url(url).build();
            }
        }
        return requestBuilder.build();
    }

    private String appendResourceVersionInObject(String namespace, String customResourceName, String customResourceAsJsonString) throws IOException {
        Map<String, Object> oldObject = this.get(namespace, customResourceName);
        String resourceVersion = ((Map)oldObject.get("metadata")).get("resourceVersion").toString();
        Map<String, Object> newObject = this.convertJsonOrYamlStringToMap(customResourceAsJsonString);
        ((Map)newObject.get("metadata")).put("resourceVersion", resourceVersion);
        return this.objectMapper.writeValueAsString(newObject);
    }

    private DeleteOptions fetchDeleteOptions(boolean cascading, String propagationPolicy) {
        DeleteOptions deleteOptions = new DeleteOptions();
        if (propagationPolicy != null) {
            deleteOptions.setPropagationPolicy(propagationPolicy);
        } else {
            deleteOptions.setOrphanDependents(!cascading);
        }
        return deleteOptions;
    }

    private static enum HttpCallMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

