/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.admissionregistration.Rule;
import io.fabric8.kubernetes.api.model.admissionregistration.RuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RuleFluentImpl<A extends RuleFluent<A>>
extends BaseFluent<A>
implements RuleFluent<A> {
    private List<String> apiGroups = new ArrayList<String>();
    private List<String> apiVersions = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private String scope;

    public RuleFluentImpl() {
    }

    public RuleFluentImpl(Rule instance) {
        this.withApiGroups(instance.getApiGroups());
        this.withApiVersions(instance.getApiVersions());
        this.withResources(instance.getResources());
        this.withScope(instance.getScope());
    }

    @Override
    public A addToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToApiGroups(String ... items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromApiGroups(String ... items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromApiGroups(Collection<String> items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    @Override
    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    @Override
    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    @Override
    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    @Override
    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withApiGroups(List<String> apiGroups) {
        if (this.apiGroups != null) {
            this._visitables.get("apiGroups").removeAll(this.apiGroups);
        }
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withApiGroups(String ... apiGroups) {
        if (this.apiGroups != null) {
            this.apiGroups.clear();
        }
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    @Override
    public A addNewApiGroup(String arg1) {
        return this.addToApiGroups(new String(arg1));
    }

    @Override
    public A addNewApiGroup(StringBuilder arg1) {
        return this.addToApiGroups(new String(arg1));
    }

    @Override
    public A addNewApiGroup(StringBuffer arg1) {
        return this.addToApiGroups(new String(arg1));
    }

    @Override
    public A addToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToApiVersions(String ... items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToApiVersions(Collection<String> items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromApiVersions(String ... items) {
        for (String item : items) {
            if (this.apiVersions == null) continue;
            this.apiVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromApiVersions(Collection<String> items) {
        for (String item : items) {
            if (this.apiVersions == null) continue;
            this.apiVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    @Override
    public String getApiVersion(int index) {
        return this.apiVersions.get(index);
    }

    @Override
    public String getFirstApiVersion() {
        return this.apiVersions.get(0);
    }

    @Override
    public String getLastApiVersion() {
        return this.apiVersions.get(this.apiVersions.size() - 1);
    }

    @Override
    public String getMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withApiVersions(List<String> apiVersions) {
        if (this.apiVersions != null) {
            this._visitables.get("apiVersions").removeAll(this.apiVersions);
        }
        if (apiVersions != null) {
            this.apiVersions = new ArrayList<String>();
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        } else {
            this.apiVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withApiVersions(String ... apiVersions) {
        if (this.apiVersions != null) {
            this.apiVersions.clear();
        }
        if (apiVersions != null) {
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasApiVersions() {
        return this.apiVersions != null && !this.apiVersions.isEmpty();
    }

    @Override
    public A addNewApiVersion(String arg1) {
        return this.addToApiVersions(new String(arg1));
    }

    @Override
    public A addNewApiVersion(StringBuilder arg1) {
        return this.addToApiVersions(new String(arg1));
    }

    @Override
    public A addNewApiVersion(StringBuffer arg1) {
        return this.addToApiVersions(new String(arg1));
    }

    @Override
    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(String ... items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<String> items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResources() {
        return this.resources;
    }

    @Override
    public String getResource(int index) {
        return this.resources.get(index);
    }

    @Override
    public String getFirstResource() {
        return this.resources.get(0);
    }

    @Override
    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    @Override
    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<String> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public A addNewResource(String arg1) {
        return this.addToResources(new String(arg1));
    }

    @Override
    public A addNewResource(StringBuilder arg1) {
        return this.addToResources(new String(arg1));
    }

    @Override
    public A addNewResource(StringBuffer arg1) {
        return this.addToResources(new String(arg1));
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    @Override
    public Boolean hasScope() {
        return this.scope != null;
    }

    @Override
    public A withNewScope(String arg1) {
        return this.withScope(new String(arg1));
    }

    @Override
    public A withNewScope(StringBuilder arg1) {
        return this.withScope(new String(arg1));
    }

    @Override
    public A withNewScope(StringBuffer arg1) {
        return this.withScope(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleFluentImpl that = (RuleFluentImpl)o;
        if (this.apiGroups != null ? !this.apiGroups.equals(that.apiGroups) : that.apiGroups != null) {
            return false;
        }
        if (this.apiVersions != null ? !this.apiVersions.equals(that.apiVersions) : that.apiVersions != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.scope != null ? !this.scope.equals(that.scope) : that.scope != null);
    }
}

