/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.CrossVersionObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetricStatus;
import io.fabric8.kubernetes.api.model.ObjectMetricStatusFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.QuantityFluentImpl;

public class ObjectMetricStatusFluentImpl<A extends ObjectMetricStatusFluent<A>>
extends BaseFluent<A>
implements ObjectMetricStatusFluent<A> {
    private QuantityBuilder averageValue;
    private QuantityBuilder currentValue;
    private String metricName;
    private LabelSelectorBuilder selector;
    private CrossVersionObjectReferenceBuilder target;

    public ObjectMetricStatusFluentImpl() {
    }

    public ObjectMetricStatusFluentImpl(ObjectMetricStatus instance) {
        this.withAverageValue(instance.getAverageValue());
        this.withCurrentValue(instance.getCurrentValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTarget(instance.getTarget());
    }

    @Override
    @Deprecated
    public Quantity getAverageValue() {
        return this.averageValue != null ? this.averageValue.build() : null;
    }

    @Override
    public Quantity buildAverageValue() {
        return this.averageValue != null ? this.averageValue.build() : null;
    }

    @Override
    public A withAverageValue(Quantity averageValue) {
        this._visitables.get("averageValue").remove(this.averageValue);
        if (averageValue != null) {
            this.averageValue = new QuantityBuilder(averageValue);
            this._visitables.get("averageValue").add(this.averageValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    @Override
    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    @Override
    public ObjectMetricStatusFluent.AverageValueNested<A> withNewAverageValue() {
        return new AverageValueNestedImpl();
    }

    @Override
    public ObjectMetricStatusFluent.AverageValueNested<A> withNewAverageValueLike(Quantity item) {
        return new AverageValueNestedImpl(item);
    }

    @Override
    public ObjectMetricStatusFluent.AverageValueNested<A> editAverageValue() {
        return this.withNewAverageValueLike(this.getAverageValue());
    }

    @Override
    public ObjectMetricStatusFluent.AverageValueNested<A> editOrNewAverageValue() {
        return this.withNewAverageValueLike(this.getAverageValue() != null ? this.getAverageValue() : new QuantityBuilder().build());
    }

    @Override
    public ObjectMetricStatusFluent.AverageValueNested<A> editOrNewAverageValueLike(Quantity item) {
        return this.withNewAverageValueLike(this.getAverageValue() != null ? this.getAverageValue() : item);
    }

    @Override
    @Deprecated
    public Quantity getCurrentValue() {
        return this.currentValue != null ? this.currentValue.build() : null;
    }

    @Override
    public Quantity buildCurrentValue() {
        return this.currentValue != null ? this.currentValue.build() : null;
    }

    @Override
    public A withCurrentValue(Quantity currentValue) {
        this._visitables.get("currentValue").remove(this.currentValue);
        if (currentValue != null) {
            this.currentValue = new QuantityBuilder(currentValue);
            this._visitables.get("currentValue").add(this.currentValue);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    @Override
    public A withNewCurrentValue(String amount, String format) {
        return this.withCurrentValue(new Quantity(amount, format));
    }

    @Override
    public A withNewCurrentValue(String amount) {
        return this.withCurrentValue(new Quantity(amount));
    }

    @Override
    public ObjectMetricStatusFluent.CurrentValueNested<A> withNewCurrentValue() {
        return new CurrentValueNestedImpl();
    }

    @Override
    public ObjectMetricStatusFluent.CurrentValueNested<A> withNewCurrentValueLike(Quantity item) {
        return new CurrentValueNestedImpl(item);
    }

    @Override
    public ObjectMetricStatusFluent.CurrentValueNested<A> editCurrentValue() {
        return this.withNewCurrentValueLike(this.getCurrentValue());
    }

    @Override
    public ObjectMetricStatusFluent.CurrentValueNested<A> editOrNewCurrentValue() {
        return this.withNewCurrentValueLike(this.getCurrentValue() != null ? this.getCurrentValue() : new QuantityBuilder().build());
    }

    @Override
    public ObjectMetricStatusFluent.CurrentValueNested<A> editOrNewCurrentValueLike(Quantity item) {
        return this.withNewCurrentValueLike(this.getCurrentValue() != null ? this.getCurrentValue() : item);
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    public A withNewMetricName(String arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuilder arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuffer arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public ObjectMetricStatusFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ObjectMetricStatusFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ObjectMetricStatusFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public CrossVersionObjectReference getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public CrossVersionObjectReference buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(CrossVersionObjectReference target) {
        this._visitables.get("target").remove(this.target);
        if (target != null) {
            this.target = new CrossVersionObjectReferenceBuilder(target);
            this._visitables.get("target").add(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public A withNewTarget(String apiVersion, String kind, String name) {
        return this.withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    @Override
    public ObjectMetricStatusFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public ObjectMetricStatusFluent.TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public ObjectMetricStatusFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public ObjectMetricStatusFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public ObjectMetricStatusFluent.TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMetricStatusFluentImpl that = (ObjectMetricStatusFluentImpl)o;
        if (this.averageValue != null ? !this.averageValue.equals(that.averageValue) : that.averageValue != null) {
            return false;
        }
        if (this.currentValue != null ? !this.currentValue.equals(that.currentValue) : that.currentValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(that.target) : that.target != null);
    }

    public class TargetNestedImpl<N>
    extends CrossVersionObjectReferenceFluentImpl<ObjectMetricStatusFluent.TargetNested<N>>
    implements ObjectMetricStatusFluent.TargetNested<N>,
    Nested<N> {
        private final CrossVersionObjectReferenceBuilder builder;

        TargetNestedImpl(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricStatusFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ObjectMetricStatusFluent.SelectorNested<N>>
    implements ObjectMetricStatusFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricStatusFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class CurrentValueNestedImpl<N>
    extends QuantityFluentImpl<ObjectMetricStatusFluent.CurrentValueNested<N>>
    implements ObjectMetricStatusFluent.CurrentValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        CurrentValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        CurrentValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricStatusFluentImpl.this.withCurrentValue(this.builder.build());
        }

        @Override
        public N endCurrentValue() {
            return this.and();
        }
    }

    public class AverageValueNestedImpl<N>
    extends QuantityFluentImpl<ObjectMetricStatusFluent.AverageValueNested<N>>
    implements ObjectMetricStatusFluent.AverageValueNested<N>,
    Nested<N> {
        private final QuantityBuilder builder;

        AverageValueNestedImpl(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        AverageValueNestedImpl() {
            this.builder = new QuantityBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetricStatusFluentImpl.this.withAverageValue(this.builder.build());
        }

        @Override
        public N endAverageValue() {
            return this.and();
        }
    }
}

