/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.ImageTagOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ImageTagHandler
implements ResourceHandler<ImageTag, ImageTagBuilder> {
    @Override
    public String getKind() {
        return ImageTag.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "image.openshift.io/v1";
    }

    @Override
    public ImageTag create(OkHttpClient client, Config config, String namespace, ImageTag item) {
        return (ImageTag)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new ImageTag[0]);
    }

    @Override
    public ImageTag replace(OkHttpClient client, Config config, String namespace, ImageTag item) {
        return ((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ImageTag reload(OkHttpClient client, Config config, String namespace, ImageTag item) {
        return (ImageTag)((Gettable)((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ImageTagBuilder edit(ImageTag item) {
        return new ImageTagBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ImageTag item) {
        return new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, Watcher<ImageTag> watcher) {
        return ((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, String resourceVersion, Watcher<ImageTag> watcher) {
        return ((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ImageTag item, ListOptions options, Watcher<ImageTag> watcher) {
        return ((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ImageTag waitUntilReady(OkHttpClient client, Config config, String namespace, ImageTag item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageTag)((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ImageTag waitUntilCondition(OkHttpClient client, Config config, String namespace, ImageTag item, Predicate<ImageTag> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ImageTag)((Resource)new ImageTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

