/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_1.ExecConfig;
import io.fabric8.kubernetes.api.model.v5_1.ExecConfigFluent;
import io.fabric8.kubernetes.api.model.v5_1.ExecConfigFluentImpl;
import java.util.Objects;

public class ExecConfigBuilder
extends ExecConfigFluentImpl<ExecConfigBuilder>
implements VisitableBuilder<ExecConfig, ExecConfigBuilder> {
    ExecConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ExecConfigBuilder() {
        this(true);
    }

    public ExecConfigBuilder(Boolean validationEnabled) {
        this(new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExecConfig(), validationEnabled);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, ExecConfig instance) {
        this(fluent, instance, true);
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, ExecConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withArgs(instance.getArgs());
        fluent.withCommand(instance.getCommand());
        fluent.withEnv(instance.getEnv());
        fluent.withInstallHint(instance.getInstallHint());
        fluent.withProvideClusterInfo(instance.getProvideClusterInfo());
        this.validationEnabled = validationEnabled;
    }

    public ExecConfigBuilder(ExecConfig instance) {
        this(instance, (Boolean)true);
    }

    public ExecConfigBuilder(ExecConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withInstallHint(instance.getInstallHint());
        this.withProvideClusterInfo(instance.getProvideClusterInfo());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ExecConfig build() {
        ExecConfig buildable = new ExecConfig(this.fluent.getApiVersion(), this.fluent.getArgs(), this.fluent.getCommand(), this.fluent.getEnv(), this.fluent.getInstallHint(), this.fluent.isProvideClusterInfo());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecConfigBuilder that = (ExecConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

