/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_1.FCVolumeSource;
import io.fabric8.kubernetes.api.model.v5_1.FCVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v5_1.FCVolumeSourceFluentImpl;
import java.util.Objects;

public class FCVolumeSourceBuilder
extends FCVolumeSourceFluentImpl<FCVolumeSourceBuilder>
implements VisitableBuilder<FCVolumeSource, FCVolumeSourceBuilder> {
    FCVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public FCVolumeSourceBuilder() {
        this(true);
    }

    public FCVolumeSourceBuilder(Boolean validationEnabled) {
        this(new FCVolumeSource(), validationEnabled);
    }

    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new FCVolumeSource(), validationEnabled);
    }

    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent, FCVolumeSource instance) {
        this(fluent, instance, true);
    }

    public FCVolumeSourceBuilder(FCVolumeSourceFluent<?> fluent, FCVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withLun(instance.getLun());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withTargetWWNs(instance.getTargetWWNs());
        fluent.withWwids(instance.getWwids());
        this.validationEnabled = validationEnabled;
    }

    public FCVolumeSourceBuilder(FCVolumeSource instance) {
        this(instance, (Boolean)true);
    }

    public FCVolumeSourceBuilder(FCVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withLun(instance.getLun());
        this.withReadOnly(instance.getReadOnly());
        this.withTargetWWNs(instance.getTargetWWNs());
        this.withWwids(instance.getWwids());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public FCVolumeSource build() {
        FCVolumeSource buildable = new FCVolumeSource(this.fluent.getFsType(), this.fluent.getLun(), this.fluent.isReadOnly(), this.fluent.getTargetWWNs(), this.fluent.getWwids());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FCVolumeSourceBuilder that = (FCVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

